/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight;

import javax.annotation.Generated;

import com.amazonaws.services.quicksight.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonQuickSight}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonQuickSight implements AmazonQuickSight {

    protected AbstractAmazonQuickSight() {
    }

    @Override
    public CancelIngestionResult cancelIngestion(CancelIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDashboardResult createDashboard(CreateDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSetResult createDataSet(CreateDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSourceResult createDataSource(CreateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupMembershipResult createGroupMembership(CreateGroupMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIAMPolicyAssignmentResult createIAMPolicyAssignment(CreateIAMPolicyAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIngestionResult createIngestion(CreateIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTemplateResult createTemplate(CreateTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTemplateAliasResult createTemplateAlias(CreateTemplateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDashboardResult deleteDashboard(DeleteDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSetResult deleteDataSet(DeleteDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGroupResult deleteGroup(DeleteGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGroupMembershipResult deleteGroupMembership(DeleteGroupMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIAMPolicyAssignmentResult deleteIAMPolicyAssignment(DeleteIAMPolicyAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTemplateResult deleteTemplate(DeleteTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTemplateAliasResult deleteTemplateAlias(DeleteTemplateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserByPrincipalIdResult deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDashboardResult describeDashboard(DescribeDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDashboardPermissionsResult describeDashboardPermissions(DescribeDashboardPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSetResult describeDataSet(DescribeDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSetPermissionsResult describeDataSetPermissions(DescribeDataSetPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSourceResult describeDataSource(DescribeDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSourcePermissionsResult describeDataSourcePermissions(DescribeDataSourcePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGroupResult describeGroup(DescribeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeIAMPolicyAssignmentResult describeIAMPolicyAssignment(DescribeIAMPolicyAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeIngestionResult describeIngestion(DescribeIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTemplateResult describeTemplate(DescribeTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTemplateAliasResult describeTemplateAlias(DescribeTemplateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTemplatePermissionsResult describeTemplatePermissions(DescribeTemplatePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeUserResult describeUser(DescribeUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDashboardEmbedUrlResult getDashboardEmbedUrl(GetDashboardEmbedUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDashboardVersionsResult listDashboardVersions(ListDashboardVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDashboardsResult listDashboards(ListDashboardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSetsResult listDataSets(ListDataSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourcesResult listDataSources(ListDataSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupMembershipsResult listGroupMemberships(ListGroupMembershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIAMPolicyAssignmentsResult listIAMPolicyAssignments(ListIAMPolicyAssignmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIAMPolicyAssignmentsForUserResult listIAMPolicyAssignmentsForUser(ListIAMPolicyAssignmentsForUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIngestionsResult listIngestions(ListIngestionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplateAliasesResult listTemplateAliases(ListTemplateAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplateVersionsResult listTemplateVersions(ListTemplateVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplatesResult listTemplates(ListTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUserGroupsResult listUserGroups(ListUserGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterUserResult registerUser(RegisterUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchDashboardsResult searchDashboards(SearchDashboardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDashboardResult updateDashboard(UpdateDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDashboardPermissionsResult updateDashboardPermissions(UpdateDashboardPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDashboardPublishedVersionResult updateDashboardPublishedVersion(UpdateDashboardPublishedVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSetResult updateDataSet(UpdateDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSetPermissionsResult updateDataSetPermissions(UpdateDataSetPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourcePermissionsResult updateDataSourcePermissions(UpdateDataSourcePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGroupResult updateGroup(UpdateGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIAMPolicyAssignmentResult updateIAMPolicyAssignment(UpdateIAMPolicyAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplateResult updateTemplate(UpdateTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplateAliasResult updateTemplateAlias(UpdateTemplateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplatePermissionsResult updateTemplatePermissions(UpdateTemplatePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
