/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.managedblockchainquery.model.TransactionOutputItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTransactionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<TransactionOutputItem> transactions;
    private String nextToken;

    public List<TransactionOutputItem> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(Collection<TransactionOutputItem> transactions) {
        if (transactions == null) {
            this.transactions = null;
            return;
        }
        this.transactions = new ArrayList<TransactionOutputItem>(transactions);
    }

    public ListTransactionsResult withTransactions(TransactionOutputItem ... transactions) {
        if (this.transactions == null) {
            this.setTransactions(new ArrayList<TransactionOutputItem>(transactions.length));
        }
        for (TransactionOutputItem ele : transactions) {
            this.transactions.add(ele);
        }
        return this;
    }

    public ListTransactionsResult withTransactions(Collection<TransactionOutputItem> transactions) {
        this.setTransactions(transactions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTransactionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTransactions() != null) {
            sb.append("Transactions: ").append(this.getTransactions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransactionsResult)) {
            return false;
        }
        ListTransactionsResult other = (ListTransactionsResult)obj;
        if (other.getTransactions() == null ^ this.getTransactions() == null) {
            return false;
        }
        if (other.getTransactions() != null && !other.getTransactions().equals(this.getTransactions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTransactions() == null ? 0 : this.getTransactions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTransactionsResult clone() {
        try {
            return (ListTransactionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

