/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iot.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A summary of information about a fleet provision template version.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ProvisioningTemplateVersionSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ID of the fleet provisioning template version.
     * </p>
     */
    private Integer versionId;
    /**
     * <p>
     * The date when the provisioning template version was created
     * </p>
     */
    private java.util.Date creationDate;
    /**
     * <p>
     * True if the provisioning template version is the default version, otherwise false.
     * </p>
     */
    private Boolean isDefaultVersion;

    /**
     * <p>
     * The ID of the fleet provisioning template version.
     * </p>
     * 
     * @param versionId
     *        The ID of the fleet provisioning template version.
     */

    public void setVersionId(Integer versionId) {
        this.versionId = versionId;
    }

    /**
     * <p>
     * The ID of the fleet provisioning template version.
     * </p>
     * 
     * @return The ID of the fleet provisioning template version.
     */

    public Integer getVersionId() {
        return this.versionId;
    }

    /**
     * <p>
     * The ID of the fleet provisioning template version.
     * </p>
     * 
     * @param versionId
     *        The ID of the fleet provisioning template version.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProvisioningTemplateVersionSummary withVersionId(Integer versionId) {
        setVersionId(versionId);
        return this;
    }

    /**
     * <p>
     * The date when the provisioning template version was created
     * </p>
     * 
     * @param creationDate
     *        The date when the provisioning template version was created
     */

    public void setCreationDate(java.util.Date creationDate) {
        this.creationDate = creationDate;
    }

    /**
     * <p>
     * The date when the provisioning template version was created
     * </p>
     * 
     * @return The date when the provisioning template version was created
     */

    public java.util.Date getCreationDate() {
        return this.creationDate;
    }

    /**
     * <p>
     * The date when the provisioning template version was created
     * </p>
     * 
     * @param creationDate
     *        The date when the provisioning template version was created
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProvisioningTemplateVersionSummary withCreationDate(java.util.Date creationDate) {
        setCreationDate(creationDate);
        return this;
    }

    /**
     * <p>
     * True if the provisioning template version is the default version, otherwise false.
     * </p>
     * 
     * @param isDefaultVersion
     *        True if the provisioning template version is the default version, otherwise false.
     */

    public void setIsDefaultVersion(Boolean isDefaultVersion) {
        this.isDefaultVersion = isDefaultVersion;
    }

    /**
     * <p>
     * True if the provisioning template version is the default version, otherwise false.
     * </p>
     * 
     * @return True if the provisioning template version is the default version, otherwise false.
     */

    public Boolean getIsDefaultVersion() {
        return this.isDefaultVersion;
    }

    /**
     * <p>
     * True if the provisioning template version is the default version, otherwise false.
     * </p>
     * 
     * @param isDefaultVersion
     *        True if the provisioning template version is the default version, otherwise false.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProvisioningTemplateVersionSummary withIsDefaultVersion(Boolean isDefaultVersion) {
        setIsDefaultVersion(isDefaultVersion);
        return this;
    }

    /**
     * <p>
     * True if the provisioning template version is the default version, otherwise false.
     * </p>
     * 
     * @return True if the provisioning template version is the default version, otherwise false.
     */

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVersionId() != null)
            sb.append("VersionId: ").append(getVersionId()).append(",");
        if (getCreationDate() != null)
            sb.append("CreationDate: ").append(getCreationDate()).append(",");
        if (getIsDefaultVersion() != null)
            sb.append("IsDefaultVersion: ").append(getIsDefaultVersion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ProvisioningTemplateVersionSummary == false)
            return false;
        ProvisioningTemplateVersionSummary other = (ProvisioningTemplateVersionSummary) obj;
        if (other.getVersionId() == null ^ this.getVersionId() == null)
            return false;
        if (other.getVersionId() != null && other.getVersionId().equals(this.getVersionId()) == false)
            return false;
        if (other.getCreationDate() == null ^ this.getCreationDate() == null)
            return false;
        if (other.getCreationDate() != null && other.getCreationDate().equals(this.getCreationDate()) == false)
            return false;
        if (other.getIsDefaultVersion() == null ^ this.getIsDefaultVersion() == null)
            return false;
        if (other.getIsDefaultVersion() != null && other.getIsDefaultVersion().equals(this.getIsDefaultVersion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getVersionId() == null) ? 0 : getVersionId().hashCode());
        hashCode = prime * hashCode + ((getCreationDate() == null) ? 0 : getCreationDate().hashCode());
        hashCode = prime * hashCode + ((getIsDefaultVersion() == null) ? 0 : getIsDefaultVersion().hashCode());
        return hashCode;
    }

    @Override
    public ProvisioningTemplateVersionSummary clone() {
        try {
            return (ProvisioningTemplateVersionSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iot.model.transform.ProvisioningTemplateVersionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
