/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.globalaccelerator.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.globalaccelerator.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateCrossAccountAttachmentRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateCrossAccountAttachmentRequestMarshaller {

    private static final MarshallingInfo<String> ATTACHMENTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachmentArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Name").build();
    private static final MarshallingInfo<List> ADDPRINCIPALS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AddPrincipals").build();
    private static final MarshallingInfo<List> REMOVEPRINCIPALS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RemovePrincipals").build();
    private static final MarshallingInfo<List> ADDRESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AddResources").build();
    private static final MarshallingInfo<List> REMOVERESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RemoveResources").build();

    private static final UpdateCrossAccountAttachmentRequestMarshaller instance = new UpdateCrossAccountAttachmentRequestMarshaller();

    public static UpdateCrossAccountAttachmentRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateCrossAccountAttachmentRequest updateCrossAccountAttachmentRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateCrossAccountAttachmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateCrossAccountAttachmentRequest.getAttachmentArn(), ATTACHMENTARN_BINDING);
            protocolMarshaller.marshall(updateCrossAccountAttachmentRequest.getName(), NAME_BINDING);
            protocolMarshaller.marshall(updateCrossAccountAttachmentRequest.getAddPrincipals(), ADDPRINCIPALS_BINDING);
            protocolMarshaller.marshall(updateCrossAccountAttachmentRequest.getRemovePrincipals(), REMOVEPRINCIPALS_BINDING);
            protocolMarshaller.marshall(updateCrossAccountAttachmentRequest.getAddResources(), ADDRESOURCES_BINDING);
            protocolMarshaller.marshall(updateCrossAccountAttachmentRequest.getRemoveResources(), REMOVERESOURCES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
