/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.globalaccelerator.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A resource is one of the following: the ARN for an Amazon Web Services resource that is supported by Global
 * Accelerator to be added as an endpoint, or a CIDR range that specifies a bring your own IP (BYOIP) address pool.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/Resource" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Resource implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The endpoint ID for the endpoint that is specified as a Amazon Web Services resource.
     * </p>
     * <p>
     * An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a Network
     * Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     * </p>
     */
    private String endpointId;
    /**
     * <p>
     * An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     * advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     * Accelerator
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the Global Accelerator Developer Guide.
     * </p>
     */
    private String cidr;
    /**
     * <p>
     * The Amazon Web Services Region where a shared endpoint resource is located.
     * </p>
     */
    private String region;

    /**
     * <p>
     * The endpoint ID for the endpoint that is specified as a Amazon Web Services resource.
     * </p>
     * <p>
     * An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a Network
     * Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     * </p>
     * 
     * @param endpointId
     *        The endpoint ID for the endpoint that is specified as a Amazon Web Services resource. </p>
     *        <p>
     *        An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a
     *        Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     */

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    /**
     * <p>
     * The endpoint ID for the endpoint that is specified as a Amazon Web Services resource.
     * </p>
     * <p>
     * An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a Network
     * Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     * </p>
     * 
     * @return The endpoint ID for the endpoint that is specified as a Amazon Web Services resource. </p>
     *         <p>
     *         An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a
     *         Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     */

    public String getEndpointId() {
        return this.endpointId;
    }

    /**
     * <p>
     * The endpoint ID for the endpoint that is specified as a Amazon Web Services resource.
     * </p>
     * <p>
     * An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a Network
     * Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     * </p>
     * 
     * @param endpointId
     *        The endpoint ID for the endpoint that is specified as a Amazon Web Services resource. </p>
     *        <p>
     *        An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a
     *        Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Resource withEndpointId(String endpointId) {
        setEndpointId(endpointId);
        return this;
    }

    /**
     * <p>
     * An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     * advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     * Accelerator
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the Global Accelerator Developer Guide.
     * </p>
     * 
     * @param cidr
     *        An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     *        advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     *        Accelerator</p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP
     *        addresses (BYOIP)</a> in the Global Accelerator Developer Guide.
     */

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    /**
     * <p>
     * An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     * advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     * Accelerator
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the Global Accelerator Developer Guide.
     * </p>
     * 
     * @return An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     *         advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     *         Accelerator</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP
     *         addresses (BYOIP)</a> in the Global Accelerator Developer Guide.
     */

    public String getCidr() {
        return this.cidr;
    }

    /**
     * <p>
     * An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     * advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     * Accelerator
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the Global Accelerator Developer Guide.
     * </p>
     * 
     * @param cidr
     *        An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     *        advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     *        Accelerator</p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP
     *        addresses (BYOIP)</a> in the Global Accelerator Developer Guide.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Resource withCidr(String cidr) {
        setCidr(cidr);
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services Region where a shared endpoint resource is located.
     * </p>
     * 
     * @param region
     *        The Amazon Web Services Region where a shared endpoint resource is located.
     */

    public void setRegion(String region) {
        this.region = region;
    }

    /**
     * <p>
     * The Amazon Web Services Region where a shared endpoint resource is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where a shared endpoint resource is located.
     */

    public String getRegion() {
        return this.region;
    }

    /**
     * <p>
     * The Amazon Web Services Region where a shared endpoint resource is located.
     * </p>
     * 
     * @param region
     *        The Amazon Web Services Region where a shared endpoint resource is located.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Resource withRegion(String region) {
        setRegion(region);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEndpointId() != null)
            sb.append("EndpointId: ").append(getEndpointId()).append(",");
        if (getCidr() != null)
            sb.append("Cidr: ").append(getCidr()).append(",");
        if (getRegion() != null)
            sb.append("Region: ").append(getRegion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Resource == false)
            return false;
        Resource other = (Resource) obj;
        if (other.getEndpointId() == null ^ this.getEndpointId() == null)
            return false;
        if (other.getEndpointId() != null && other.getEndpointId().equals(this.getEndpointId()) == false)
            return false;
        if (other.getCidr() == null ^ this.getCidr() == null)
            return false;
        if (other.getCidr() != null && other.getCidr().equals(this.getCidr()) == false)
            return false;
        if (other.getRegion() == null ^ this.getRegion() == null)
            return false;
        if (other.getRegion() != null && other.getRegion().equals(this.getRegion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEndpointId() == null) ? 0 : getEndpointId().hashCode());
        hashCode = prime * hashCode + ((getCidr() == null) ? 0 : getCidr().hashCode());
        hashCode = prime * hashCode + ((getRegion() == null) ? 0 : getRegion().hashCode());
        return hashCode;
    }

    @Override
    public Resource clone() {
        try {
            return (Resource) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.globalaccelerator.model.transform.ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
