/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.eks.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeAddonVersionsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The list of available versions with Kubernetes version compatibility and other properties.
     * </p>
     */
    private java.util.List<AddonInfo> addons;
    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeAddonVersions</code> request. When the
     * results of a <code>DescribeAddonVersions</code> request exceed <code>maxResults</code>, you can use this value to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     */
    private String nextToken;

    /**
     * <p>
     * The list of available versions with Kubernetes version compatibility and other properties.
     * </p>
     * 
     * @return The list of available versions with Kubernetes version compatibility and other properties.
     */

    public java.util.List<AddonInfo> getAddons() {
        return addons;
    }

    /**
     * <p>
     * The list of available versions with Kubernetes version compatibility and other properties.
     * </p>
     * 
     * @param addons
     *        The list of available versions with Kubernetes version compatibility and other properties.
     */

    public void setAddons(java.util.Collection<AddonInfo> addons) {
        if (addons == null) {
            this.addons = null;
            return;
        }

        this.addons = new java.util.ArrayList<AddonInfo>(addons);
    }

    /**
     * <p>
     * The list of available versions with Kubernetes version compatibility and other properties.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAddons(java.util.Collection)} or {@link #withAddons(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param addons
     *        The list of available versions with Kubernetes version compatibility and other properties.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeAddonVersionsResult withAddons(AddonInfo... addons) {
        if (this.addons == null) {
            setAddons(new java.util.ArrayList<AddonInfo>(addons.length));
        }
        for (AddonInfo ele : addons) {
            this.addons.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of available versions with Kubernetes version compatibility and other properties.
     * </p>
     * 
     * @param addons
     *        The list of available versions with Kubernetes version compatibility and other properties.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeAddonVersionsResult withAddons(java.util.Collection<AddonInfo> addons) {
        setAddons(addons);
        return this;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeAddonVersions</code> request. When the
     * results of a <code>DescribeAddonVersions</code> request exceed <code>maxResults</code>, you can use this value to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @param nextToken
     *        The <code>nextToken</code> value to include in a future <code>DescribeAddonVersions</code> request. When
     *        the results of a <code>DescribeAddonVersions</code> request exceed <code>maxResults</code>, you can use
     *        this value to retrieve the next page of results. This value is <code>null</code> when there are no more
     *        results to return.</p> <note>
     *        <p>
     *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *        list and not for other programmatic purposes.
     *        </p>
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeAddonVersions</code> request. When the
     * results of a <code>DescribeAddonVersions</code> request exceed <code>maxResults</code>, you can use this value to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeAddonVersions</code> request. When
     *         the results of a <code>DescribeAddonVersions</code> request exceed <code>maxResults</code>, you can use
     *         this value to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeAddonVersions</code> request. When the
     * results of a <code>DescribeAddonVersions</code> request exceed <code>maxResults</code>, you can use this value to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @param nextToken
     *        The <code>nextToken</code> value to include in a future <code>DescribeAddonVersions</code> request. When
     *        the results of a <code>DescribeAddonVersions</code> request exceed <code>maxResults</code>, you can use
     *        this value to retrieve the next page of results. This value is <code>null</code> when there are no more
     *        results to return.</p> <note>
     *        <p>
     *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *        list and not for other programmatic purposes.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeAddonVersionsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAddons() != null)
            sb.append("Addons: ").append(getAddons()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeAddonVersionsResult == false)
            return false;
        DescribeAddonVersionsResult other = (DescribeAddonVersionsResult) obj;
        if (other.getAddons() == null ^ this.getAddons() == null)
            return false;
        if (other.getAddons() != null && other.getAddons().equals(this.getAddons()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAddons() == null) ? 0 : getAddons().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribeAddonVersionsResult clone() {
        try {
            return (DescribeAddonVersionsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
