/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.databasemigrationservice.model.DataProviderDescriptorDefinition;
import com.amazonaws.services.databasemigrationservice.model.SCApplicationAttributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyMigrationProjectRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String migrationProjectIdentifier;
    private String migrationProjectName;
    private List<DataProviderDescriptorDefinition> sourceDataProviderDescriptors;
    private List<DataProviderDescriptorDefinition> targetDataProviderDescriptors;
    private String instanceProfileIdentifier;
    private String transformationRules;
    private String description;
    private SCApplicationAttributes schemaConversionApplicationAttributes;

    public void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
        this.migrationProjectIdentifier = migrationProjectIdentifier;
    }

    public String getMigrationProjectIdentifier() {
        return this.migrationProjectIdentifier;
    }

    public ModifyMigrationProjectRequest withMigrationProjectIdentifier(String migrationProjectIdentifier) {
        this.setMigrationProjectIdentifier(migrationProjectIdentifier);
        return this;
    }

    public void setMigrationProjectName(String migrationProjectName) {
        this.migrationProjectName = migrationProjectName;
    }

    public String getMigrationProjectName() {
        return this.migrationProjectName;
    }

    public ModifyMigrationProjectRequest withMigrationProjectName(String migrationProjectName) {
        this.setMigrationProjectName(migrationProjectName);
        return this;
    }

    public List<DataProviderDescriptorDefinition> getSourceDataProviderDescriptors() {
        return this.sourceDataProviderDescriptors;
    }

    public void setSourceDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> sourceDataProviderDescriptors) {
        if (sourceDataProviderDescriptors == null) {
            this.sourceDataProviderDescriptors = null;
            return;
        }
        this.sourceDataProviderDescriptors = new ArrayList<DataProviderDescriptorDefinition>(sourceDataProviderDescriptors);
    }

    public ModifyMigrationProjectRequest withSourceDataProviderDescriptors(DataProviderDescriptorDefinition ... sourceDataProviderDescriptors) {
        if (this.sourceDataProviderDescriptors == null) {
            this.setSourceDataProviderDescriptors(new ArrayList<DataProviderDescriptorDefinition>(sourceDataProviderDescriptors.length));
        }
        for (DataProviderDescriptorDefinition ele : sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors.add(ele);
        }
        return this;
    }

    public ModifyMigrationProjectRequest withSourceDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> sourceDataProviderDescriptors) {
        this.setSourceDataProviderDescriptors(sourceDataProviderDescriptors);
        return this;
    }

    public List<DataProviderDescriptorDefinition> getTargetDataProviderDescriptors() {
        return this.targetDataProviderDescriptors;
    }

    public void setTargetDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> targetDataProviderDescriptors) {
        if (targetDataProviderDescriptors == null) {
            this.targetDataProviderDescriptors = null;
            return;
        }
        this.targetDataProviderDescriptors = new ArrayList<DataProviderDescriptorDefinition>(targetDataProviderDescriptors);
    }

    public ModifyMigrationProjectRequest withTargetDataProviderDescriptors(DataProviderDescriptorDefinition ... targetDataProviderDescriptors) {
        if (this.targetDataProviderDescriptors == null) {
            this.setTargetDataProviderDescriptors(new ArrayList<DataProviderDescriptorDefinition>(targetDataProviderDescriptors.length));
        }
        for (DataProviderDescriptorDefinition ele : targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors.add(ele);
        }
        return this;
    }

    public ModifyMigrationProjectRequest withTargetDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> targetDataProviderDescriptors) {
        this.setTargetDataProviderDescriptors(targetDataProviderDescriptors);
        return this;
    }

    public void setInstanceProfileIdentifier(String instanceProfileIdentifier) {
        this.instanceProfileIdentifier = instanceProfileIdentifier;
    }

    public String getInstanceProfileIdentifier() {
        return this.instanceProfileIdentifier;
    }

    public ModifyMigrationProjectRequest withInstanceProfileIdentifier(String instanceProfileIdentifier) {
        this.setInstanceProfileIdentifier(instanceProfileIdentifier);
        return this;
    }

    public void setTransformationRules(String transformationRules) {
        this.transformationRules = transformationRules;
    }

    public String getTransformationRules() {
        return this.transformationRules;
    }

    public ModifyMigrationProjectRequest withTransformationRules(String transformationRules) {
        this.setTransformationRules(transformationRules);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ModifyMigrationProjectRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSchemaConversionApplicationAttributes(SCApplicationAttributes schemaConversionApplicationAttributes) {
        this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes;
    }

    public SCApplicationAttributes getSchemaConversionApplicationAttributes() {
        return this.schemaConversionApplicationAttributes;
    }

    public ModifyMigrationProjectRequest withSchemaConversionApplicationAttributes(SCApplicationAttributes schemaConversionApplicationAttributes) {
        this.setSchemaConversionApplicationAttributes(schemaConversionApplicationAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMigrationProjectIdentifier() != null) {
            sb.append("MigrationProjectIdentifier: ").append(this.getMigrationProjectIdentifier()).append(",");
        }
        if (this.getMigrationProjectName() != null) {
            sb.append("MigrationProjectName: ").append(this.getMigrationProjectName()).append(",");
        }
        if (this.getSourceDataProviderDescriptors() != null) {
            sb.append("SourceDataProviderDescriptors: ").append(this.getSourceDataProviderDescriptors()).append(",");
        }
        if (this.getTargetDataProviderDescriptors() != null) {
            sb.append("TargetDataProviderDescriptors: ").append(this.getTargetDataProviderDescriptors()).append(",");
        }
        if (this.getInstanceProfileIdentifier() != null) {
            sb.append("InstanceProfileIdentifier: ").append(this.getInstanceProfileIdentifier()).append(",");
        }
        if (this.getTransformationRules() != null) {
            sb.append("TransformationRules: ").append(this.getTransformationRules()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSchemaConversionApplicationAttributes() != null) {
            sb.append("SchemaConversionApplicationAttributes: ").append(this.getSchemaConversionApplicationAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyMigrationProjectRequest)) {
            return false;
        }
        ModifyMigrationProjectRequest other = (ModifyMigrationProjectRequest)obj;
        if (other.getMigrationProjectIdentifier() == null ^ this.getMigrationProjectIdentifier() == null) {
            return false;
        }
        if (other.getMigrationProjectIdentifier() != null && !other.getMigrationProjectIdentifier().equals(this.getMigrationProjectIdentifier())) {
            return false;
        }
        if (other.getMigrationProjectName() == null ^ this.getMigrationProjectName() == null) {
            return false;
        }
        if (other.getMigrationProjectName() != null && !other.getMigrationProjectName().equals(this.getMigrationProjectName())) {
            return false;
        }
        if (other.getSourceDataProviderDescriptors() == null ^ this.getSourceDataProviderDescriptors() == null) {
            return false;
        }
        if (other.getSourceDataProviderDescriptors() != null && !other.getSourceDataProviderDescriptors().equals(this.getSourceDataProviderDescriptors())) {
            return false;
        }
        if (other.getTargetDataProviderDescriptors() == null ^ this.getTargetDataProviderDescriptors() == null) {
            return false;
        }
        if (other.getTargetDataProviderDescriptors() != null && !other.getTargetDataProviderDescriptors().equals(this.getTargetDataProviderDescriptors())) {
            return false;
        }
        if (other.getInstanceProfileIdentifier() == null ^ this.getInstanceProfileIdentifier() == null) {
            return false;
        }
        if (other.getInstanceProfileIdentifier() != null && !other.getInstanceProfileIdentifier().equals(this.getInstanceProfileIdentifier())) {
            return false;
        }
        if (other.getTransformationRules() == null ^ this.getTransformationRules() == null) {
            return false;
        }
        if (other.getTransformationRules() != null && !other.getTransformationRules().equals(this.getTransformationRules())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSchemaConversionApplicationAttributes() == null ^ this.getSchemaConversionApplicationAttributes() == null) {
            return false;
        }
        return other.getSchemaConversionApplicationAttributes() == null || other.getSchemaConversionApplicationAttributes().equals(this.getSchemaConversionApplicationAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMigrationProjectIdentifier() == null ? 0 : this.getMigrationProjectIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getMigrationProjectName() == null ? 0 : this.getMigrationProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDataProviderDescriptors() == null ? 0 : this.getSourceDataProviderDescriptors().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDataProviderDescriptors() == null ? 0 : this.getTargetDataProviderDescriptors().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileIdentifier() == null ? 0 : this.getInstanceProfileIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTransformationRules() == null ? 0 : this.getTransformationRules().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaConversionApplicationAttributes() == null ? 0 : this.getSchemaConversionApplicationAttributes().hashCode());
        return hashCode;
    }

    public ModifyMigrationProjectRequest clone() {
        return (ModifyMigrationProjectRequest)super.clone();
    }
}

