/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.FunctionAssociation;
import com.amazonaws.services.cloudfront.model.FunctionAssociations;
import com.amazonaws.services.cloudfront.model.transform.FunctionAssociationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class FunctionAssociationsStaxUnmarshaller
implements Unmarshaller<FunctionAssociations, StaxUnmarshallerContext> {
    private static FunctionAssociationsStaxUnmarshaller instance;

    public FunctionAssociations unmarshall(StaxUnmarshallerContext context) throws Exception {
        FunctionAssociations functionAssociations = new FunctionAssociations();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return functionAssociations;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    functionAssociations.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    functionAssociations.withItems(new ArrayList<FunctionAssociation>());
                    continue;
                }
                if (!context.testExpression("Items/FunctionAssociation", targetDepth)) continue;
                functionAssociations.withItems(FunctionAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return functionAssociations;
    }

    public static FunctionAssociationsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FunctionAssociationsStaxUnmarshaller();
        }
        return instance;
    }
}

