/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.model.Shard;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShardSyncTask
implements ITask {
    private static final Log LOG = LogFactory.getLog(ShardSyncTask.class);
    private final IKinesisProxy kinesisProxy;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private InitialPositionInStreamExtended initialPosition;
    private final boolean cleanupLeasesUponShardCompletion;
    private final boolean ignoreUnexpectedChildShards;
    private final long shardSyncTaskIdleTimeMillis;
    private final TaskType taskType = TaskType.SHARDSYNC;
    private final ShardSyncer shardSyncer;
    private final List<Shard> latestShards;

    public ShardSyncTask(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncTaskIdleTimeMillis, ShardSyncer shardSyncer, List<Shard> latestShards) {
        this.latestShards = latestShards;
        this.kinesisProxy = kinesisProxy;
        this.leaseManager = leaseManager;
        this.initialPosition = initialPositionInStream;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncTaskIdleTimeMillis = shardSyncTaskIdleTimeMillis;
        this.shardSyncer = shardSyncer;
    }

    @Override
    public TaskResult call() {
        Exception exception = null;
        try {
            this.shardSyncer.checkAndCreateLeasesForNewShards(this.kinesisProxy, this.leaseManager, this.initialPosition, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, this.latestShards);
            if (this.shardSyncTaskIdleTimeMillis > 0L) {
                Thread.sleep(this.shardSyncTaskIdleTimeMillis);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Caught exception while sync'ing Kinesis shards and leases", (Throwable)e);
            exception = e;
        }
        return new TaskResult(exception);
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }
}

