/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.proactiveEvents;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Event {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="payload")
    private Object payload = null;

    private Event() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Event(Builder builder) {
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.payload != null) {
            this.payload = builder.payload;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="payload")
    public Object getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event servicesProactiveEventsEvent = (Event)o;
        return Objects.equals(this.name, servicesProactiveEventsEvent.name) && Objects.equals(this.payload, servicesProactiveEventsEvent.payload);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.payload);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private Object payload;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="payload")
        public Builder withPayload(Object payload) {
            this.payload = payload;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

