/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.datastore.v1;

import com.amazon.ask.model.services.datastore.v1.Command;
import com.amazon.ask.model.services.datastore.v1.Target;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class CommandsRequest {
    @JsonProperty(value="commands")
    private List<Command> commands = new ArrayList<Command>();
    @JsonProperty(value="target")
    private Target target = null;
    @JsonProperty(value="attemptDeliveryUntil")
    private String attemptDeliveryUntil = null;

    private CommandsRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private CommandsRequest(Builder builder) {
        if (builder.commands != null) {
            this.commands = builder.commands;
        }
        if (builder.target != null) {
            this.target = builder.target;
        }
        if (builder.attemptDeliveryUntil != null) {
            this.attemptDeliveryUntil = builder.attemptDeliveryUntil;
        }
    }

    @JsonProperty(value="commands")
    public List<Command> getCommands() {
        return this.commands;
    }

    @JsonProperty(value="target")
    public Target getTarget() {
        return this.target;
    }

    @JsonProperty(value="attemptDeliveryUntil")
    public String getAttemptDeliveryUntil() {
        return this.attemptDeliveryUntil;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandsRequest servicesDatastoreV1CommandsRequest = (CommandsRequest)o;
        return Objects.equals(this.commands, servicesDatastoreV1CommandsRequest.commands) && Objects.equals(this.target, servicesDatastoreV1CommandsRequest.target) && Objects.equals(this.attemptDeliveryUntil, servicesDatastoreV1CommandsRequest.attemptDeliveryUntil);
    }

    public int hashCode() {
        return Objects.hash(this.commands, this.target, this.attemptDeliveryUntil);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommandsRequest {\n");
        sb.append("    commands: ").append(this.toIndentedString(this.commands)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    attemptDeliveryUntil: ").append(this.toIndentedString(this.attemptDeliveryUntil)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<Command> commands;
        private Target target;
        private String attemptDeliveryUntil;

        private Builder() {
        }

        @JsonProperty(value="commands")
        public Builder withCommands(List<Command> commands) {
            this.commands = commands;
            return this;
        }

        public Builder addCommandsItem(Command commandsItem) {
            if (this.commands == null) {
                this.commands = new ArrayList<Command>();
            }
            this.commands.add(commandsItem);
            return this;
        }

        @JsonProperty(value="target")
        public Builder withTarget(Target target) {
            this.target = target;
            return this;
        }

        @JsonProperty(value="attemptDeliveryUntil")
        public Builder withAttemptDeliveryUntil(String attemptDeliveryUntil) {
            this.attemptDeliveryUntil = attemptDeliveryUntil;
            return this;
        }

        public CommandsRequest build() {
            return new CommandsRequest(this);
        }
    }
}

