/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.datastore;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.AuthenticationConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.DefaultApiConfiguration;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.datastore.DatastoreService;
import com.amazon.ask.model.services.datastore.v1.CancelCommandsRequestError;
import com.amazon.ask.model.services.datastore.v1.CommandsRequest;
import com.amazon.ask.model.services.datastore.v1.CommandsRequestError;
import com.amazon.ask.model.services.datastore.v1.CommandsResponse;
import com.amazon.ask.model.services.datastore.v1.QueuedResultRequestError;
import com.amazon.ask.model.services.datastore.v1.QueuedResultResponse;
import com.amazon.ask.model.services.lwa.LwaClient;
import com.amazon.ask.model.services.lwa.model.GrantType;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class DatastoreServiceClient
extends BaseServiceClient
implements DatastoreService {
    private final UserAgentHelper userAgentHelper;
    private final LwaClient lwaClient;

    public DatastoreServiceClient(ApiConfiguration apiConfiguration, AuthenticationConfiguration authenticationConfiguration) {
        super(apiConfiguration);
        this.lwaClient = LwaClient.builder().withAuthenticationConfiguration(authenticationConfiguration).withGrantType(GrantType.CLIENT_CREDENTIALS).withApiConfiguration((ApiConfiguration)DefaultApiConfiguration.builder().withApiClient(apiConfiguration.getApiClient()).withSerializer(apiConfiguration.getSerializer()).build()).build();
        this.userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.79.0").build();
    }

    public DatastoreServiceClient(ApiConfiguration apiConfiguration, LwaClient lwaClient) {
        super(apiConfiguration);
        this.lwaClient = lwaClient;
        this.userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.79.0").build();
    }

    @Override
    public ApiResponse<CommandsResponse> callCommandsV1(CommandsRequest commandsRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String accessToken = this.lwaClient.getAccessTokenForScope("alexa::datastore");
        headerParams.add(new Pair((Object)"Authorization", (Object)("Bearer " + accessToken)));
        String resourcePath = "/v1/datastore/commands";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(CommandsResponse.class, 200, "Multiple CommandsDispatchResults in response."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CommandsRequestError.class, 400, "Request validation fails."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CommandsRequestError.class, 401, "Not Authorized."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CommandsRequestError.class, 403, "The skill is not allowed to execute commands."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CommandsRequestError.class, 429, "The client has made more calls than the allowed limit."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CommandsRequestError.class, 0, "Unexpected error."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, commandsRequest, CommandsResponse.class, false);
    }

    @Override
    public CommandsResponse commandsV1(CommandsRequest commandsRequest) throws ServiceException {
        return (CommandsResponse)this.callCommandsV1(commandsRequest).getResponse();
    }

    @Override
    public ApiResponse<Void> callCancelCommandsV1(String queuedResultId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("queuedResultId", queuedResultId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String accessToken = this.lwaClient.getAccessTokenForScope("alexa::datastore");
        headerParams.add(new Pair((Object)"Authorization", (Object)("Bearer " + accessToken)));
        String resourcePath = "/v1/datastore/queue/{queuedResultId}/cancel";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 204, "Success. No content."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CancelCommandsRequestError.class, 400, "Request validation fails."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CancelCommandsRequestError.class, 401, "Not Authorized."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CancelCommandsRequestError.class, 403, "The skill is not allowed to call this API commands."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CancelCommandsRequestError.class, 404, "Unable to find the pending request."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CancelCommandsRequestError.class, 429, "The client has made more calls than the allowed limit."));
        serviceResponseDefinitions.add(new ServiceClientResponse(CancelCommandsRequestError.class, 0, "Unexpected error."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null, false);
    }

    @Override
    public void cancelCommandsV1(String queuedResultId) throws ServiceException {
        this.callCancelCommandsV1(queuedResultId).getResponse();
    }

    @Override
    public ApiResponse<QueuedResultResponse> callQueuedResultV1(String queuedResultId, Integer maxResults, String nextToken) throws ServiceException {
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        if (maxResults != null) {
            queryParams.add(new Pair((Object)"maxResults", (Object)maxResults.toString()));
        }
        if (nextToken != null) {
            queryParams.add(new Pair((Object)"nextToken", (Object)nextToken));
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("queuedResultId", queuedResultId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String accessToken = this.lwaClient.getAccessTokenForScope("alexa::datastore");
        headerParams.add(new Pair((Object)"Authorization", (Object)("Bearer " + accessToken)));
        String resourcePath = "/v1/datastore/queue/{queuedResultId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(QueuedResultResponse.class, 200, "Unordered array of CommandsDispatchResult and pagination details."));
        serviceResponseDefinitions.add(new ServiceClientResponse(QueuedResultRequestError.class, 400, "Request validation fails."));
        serviceResponseDefinitions.add(new ServiceClientResponse(QueuedResultRequestError.class, 401, "Not Authorized."));
        serviceResponseDefinitions.add(new ServiceClientResponse(QueuedResultRequestError.class, 403, "The skill is not allowed to call this API commands."));
        serviceResponseDefinitions.add(new ServiceClientResponse(QueuedResultRequestError.class, 429, "The client has made more calls than the allowed limit."));
        serviceResponseDefinitions.add(new ServiceClientResponse(QueuedResultRequestError.class, 0, "Unexpected error."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, QueuedResultResponse.class, false);
    }

    @Override
    public QueuedResultResponse queuedResultV1(String queuedResultId, Integer maxResults, String nextToken) throws ServiceException {
        return (QueuedResultResponse)this.callQueuedResultV1(queuedResultId, maxResults, nextToken).getResponse();
    }
}

