/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.gadgetController;

import com.amazon.ask.model.Directive;
import com.amazon.ask.model.services.gadgetController.SetLightParameters;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SetLightDirective
extends Directive {
    @JsonProperty(value="version")
    private Integer version = null;
    @JsonProperty(value="targetGadgets")
    private List<String> targetGadgets = new ArrayList<String>();
    @JsonProperty(value="parameters")
    private SetLightParameters parameters = null;

    private SetLightDirective() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SetLightDirective(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "GadgetController.SetLight";
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.targetGadgets != null) {
            this.targetGadgets = builder.targetGadgets;
        }
        if (builder.parameters != null) {
            this.parameters = builder.parameters;
        }
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="targetGadgets")
    public List<String> getTargetGadgets() {
        return this.targetGadgets;
    }

    @JsonProperty(value="parameters")
    public SetLightParameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetLightDirective interfacesGadgetControllerSetLightDirective = (SetLightDirective)o;
        return Objects.equals(this.version, interfacesGadgetControllerSetLightDirective.version) && Objects.equals(this.targetGadgets, interfacesGadgetControllerSetLightDirective.targetGadgets) && Objects.equals(this.parameters, interfacesGadgetControllerSetLightDirective.parameters) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.version, this.targetGadgets, this.parameters, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetLightDirective {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    targetGadgets: ").append(this.toIndentedString(this.targetGadgets)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Integer version;
        private List<String> targetGadgets;
        private SetLightParameters parameters;

        private Builder() {
        }

        @JsonProperty(value="version")
        public Builder withVersion(Integer version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="targetGadgets")
        public Builder withTargetGadgets(List<String> targetGadgets) {
            this.targetGadgets = targetGadgets;
            return this;
        }

        public Builder addTargetGadgetsItem(String targetGadgetsItem) {
            if (this.targetGadgets == null) {
                this.targetGadgets = new ArrayList<String>();
            }
            this.targetGadgets.add(targetGadgetsItem);
            return this;
        }

        @JsonProperty(value="parameters")
        public Builder withParameters(SetLightParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public SetLightDirective build() {
            return new SetLightDirective(this);
        }
    }
}

