/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.html;

import com.amazon.ask.model.interfaces.alexa.presentation.html.RuntimeErrorReason;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class RuntimeError {
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="code")
    private String code = null;

    private RuntimeError() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RuntimeError(Builder builder) {
        if (builder.reason != null) {
            this.reason = builder.reason;
        }
        if (builder.message != null) {
            this.message = builder.message;
        }
        if (builder.code != null) {
            this.code = builder.code;
        }
    }

    public RuntimeErrorReason getReason() {
        return RuntimeErrorReason.fromValue(this.reason);
    }

    @JsonProperty(value="reason")
    public String getReasonAsString() {
        return this.reason;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeError interfacesAlexaPresentationHtmlRuntimeError = (RuntimeError)o;
        return Objects.equals(this.reason, interfacesAlexaPresentationHtmlRuntimeError.reason) && Objects.equals(this.message, interfacesAlexaPresentationHtmlRuntimeError.message) && Objects.equals(this.code, interfacesAlexaPresentationHtmlRuntimeError.code);
    }

    public int hashCode() {
        return Objects.hash(this.reason, this.message, this.code);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuntimeError {\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String reason;
        private String message;
        private String code;

        private Builder() {
        }

        @JsonProperty(value="reason")
        public Builder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder withReason(RuntimeErrorReason reason) {
            this.reason = reason != null ? reason.toString() : null;
            return this;
        }

        @JsonProperty(value="message")
        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="code")
        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public RuntimeError build() {
            return new RuntimeError(this);
        }
    }
}

