/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.events.skillevents;

import com.amazon.ask.model.events.skillevents.Permission;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PermissionBody {
    @JsonProperty(value="acceptedPermissions")
    private List<Permission> acceptedPermissions = new ArrayList<Permission>();
    @JsonProperty(value="acceptedPersonPermissions")
    private List<Permission> acceptedPersonPermissions = new ArrayList<Permission>();

    private PermissionBody() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private PermissionBody(Builder builder) {
        if (builder.acceptedPermissions != null) {
            this.acceptedPermissions = builder.acceptedPermissions;
        }
        if (builder.acceptedPersonPermissions != null) {
            this.acceptedPersonPermissions = builder.acceptedPersonPermissions;
        }
    }

    @JsonProperty(value="acceptedPermissions")
    public List<Permission> getAcceptedPermissions() {
        return this.acceptedPermissions;
    }

    @JsonProperty(value="acceptedPersonPermissions")
    public List<Permission> getAcceptedPersonPermissions() {
        return this.acceptedPersonPermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionBody eventsSkilleventsPermissionBody = (PermissionBody)o;
        return Objects.equals(this.acceptedPermissions, eventsSkilleventsPermissionBody.acceptedPermissions) && Objects.equals(this.acceptedPersonPermissions, eventsSkilleventsPermissionBody.acceptedPersonPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.acceptedPermissions, this.acceptedPersonPermissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionBody {\n");
        sb.append("    acceptedPermissions: ").append(this.toIndentedString(this.acceptedPermissions)).append("\n");
        sb.append("    acceptedPersonPermissions: ").append(this.toIndentedString(this.acceptedPersonPermissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<Permission> acceptedPermissions;
        private List<Permission> acceptedPersonPermissions;

        private Builder() {
        }

        @JsonProperty(value="acceptedPermissions")
        public Builder withAcceptedPermissions(List<Permission> acceptedPermissions) {
            this.acceptedPermissions = acceptedPermissions;
            return this;
        }

        public Builder addAcceptedPermissionsItem(Permission acceptedPermissionsItem) {
            if (this.acceptedPermissions == null) {
                this.acceptedPermissions = new ArrayList<Permission>();
            }
            this.acceptedPermissions.add(acceptedPermissionsItem);
            return this;
        }

        @JsonProperty(value="acceptedPersonPermissions")
        public Builder withAcceptedPersonPermissions(List<Permission> acceptedPersonPermissions) {
            this.acceptedPersonPermissions = acceptedPersonPermissions;
            return this;
        }

        public Builder addAcceptedPersonPermissionsItem(Permission acceptedPersonPermissionsItem) {
            if (this.acceptedPersonPermissions == null) {
                this.acceptedPersonPermissions = new ArrayList<Permission>();
            }
            this.acceptedPersonPermissions.add(acceptedPersonPermissionsItem);
            return this;
        }

        public PermissionBody build() {
            return new PermissionBody(this);
        }
    }
}

