/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.util;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentHelper {
    private static Logger logger = LoggerFactory.getLogger(UserAgentHelper.class);
    private final String sdkVersion;
    private final String customUserAgent;

    protected UserAgentHelper(String sdkVersion, String customUserAgent) {
        this.sdkVersion = sdkVersion;
        this.customUserAgent = customUserAgent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserAgent() {
        Properties systemProperties;
        try {
            systemProperties = System.getProperties();
        }
        catch (SecurityException e) {
            logger.debug("Unable to determine JVM version due to security restrictions.");
            systemProperties = null;
        }
        return this.internalGetUserAgent(systemProperties, this.customUserAgent);
    }

    String internalGetUserAgent(Properties systemProperties, String customUserAgent) {
        String version = this.sdkVersion != null ? this.sdkVersion : "UNKNOWN";
        String coreUserAgent = String.format("ask-java-model/%s Java/%s", version, UserAgentHelper.getJavaVersion(systemProperties));
        return coreUserAgent + (customUserAgent != null ? " " + customUserAgent : "");
    }

    private static String getJavaVersion(Properties systemProperties) {
        if (systemProperties != null && systemProperties.getProperty("java.version") != null) {
            return systemProperties.getProperty("java.version");
        }
        return "UNKNOWN";
    }

    public static final class Builder {
        private String sdkVersion;
        private String customUserAgent;

        private Builder() {
        }

        public Builder withSdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        public Builder withCustomUserAgent(String customUserAgent) {
            this.customUserAgent = customUserAgent;
            return this;
        }

        public UserAgentHelper build() {
            return new UserAgentHelper(this.sdkVersion, this.customUserAgent);
        }
    }
}

