/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.zookeeper;

import cn.ponfee.scheduler.common.base.exception.Throwables;
import cn.ponfee.scheduler.common.util.ObjectUtils;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.registry.ServerRegistry;
import cn.ponfee.scheduler.registry.zookeeper.CuratorFrameworkClient;
import cn.ponfee.scheduler.registry.zookeeper.configuration.ZookeeperProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public abstract class ZookeeperServerRegistry<R extends Server, D extends Server>
extends ServerRegistry<R, D> {
    private static final int CREATE_EPHEMERAL_FAIL_RETRIES = 3;
    private final CuratorFrameworkClient client;

    protected ZookeeperServerRegistry(String namespace, ZookeeperProperties props) {
        super(namespace, '/');
        String registryRootPath0 = this.separator + this.registryRootPath;
        String discoveryRootPath0 = this.separator + this.discoveryRootPath;
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.client = new CuratorFrameworkClient(props, client0 -> {
                if (this.closed) {
                    return;
                }
                for (Server server : this.registered) {
                    try {
                        client0.createEphemeral(this.buildRegistryPath(server), 3);
                    }
                    catch (Exception e) {
                        this.log.error("Re-registry server to zookeeper occur error: " + server, (Throwable)e);
                    }
                }
            });
            this.client.createPersistent(registryRootPath0);
            this.client.createPersistent(discoveryRootPath0);
            this.client.watchChildChanged(discoveryRootPath0, latch, this::doRefreshDiscoveryServers);
        }
        catch (Exception e) {
            throw new IllegalStateException("Connect zookeeper failed: " + props, e);
        }
        finally {
            latch.countDown();
        }
    }

    public final boolean isConnected() {
        return this.client.isConnected();
    }

    public final void register(R server) {
        if (this.closed) {
            return;
        }
        try {
            this.client.createEphemeral(this.buildRegistryPath(server), 3);
            this.registered.add(server);
            this.log.info("Server registered: {} - {}", (Object)this.registryRole.name(), server);
        }
        catch (Throwable e) {
            throw new RuntimeException("Register to zookeeper failed: " + server, e);
        }
    }

    public final void deregister(R server) {
        String registryPath = this.buildRegistryPath(server);
        try {
            this.registered.remove(server);
            this.client.deletePath(registryPath);
            this.log.info("Server deregister: {} - {}", (Object)this.registryRole.name(), server);
        }
        catch (Throwable e) {
            this.log.error("Deregister to zookeeper failed: " + registryPath, e);
        }
    }

    public void close() {
        this.closed = true;
        if (!this.close.compareAndSet(false, true)) {
            this.log.warn("Repeat call close method\n{}", (Object)ObjectUtils.getStackTrace());
            return;
        }
        this.registered.forEach(this::deregister);
        Throwables.caught(this.client::close);
        this.registered.clear();
        super.close();
    }

    private String buildRegistryPath(R server) {
        return this.separator + this.registryRootPath + this.separator + server.serialize();
    }

    private synchronized void doRefreshDiscoveryServers(List<String> list) {
        List servers;
        this.log.info("Watched servers: " + list);
        if (CollectionUtils.isEmpty(list)) {
            this.log.error("Not discovered available {} from zookeeper.", (Object)this.discoveryRole.name());
            servers = Collections.emptyList();
        } else {
            servers = list.stream().filter(Objects::nonNull).map(s -> this.discoveryRole.deserialize(s)).collect(Collectors.toList());
        }
        this.refreshDiscoveredServers(servers);
    }
}

