/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.user;

import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.BaseClient;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.common.model.NoDisturbPayload;
import cn.jmessage.api.common.model.RegisterInfo;
import cn.jmessage.api.common.model.RegisterPayload;
import cn.jmessage.api.common.model.UserPayload;
import cn.jmessage.api.common.model.friend.FriendNote;
import cn.jmessage.api.common.model.friend.FriendNotePayload;
import cn.jmessage.api.common.model.group.GroupShieldPayload;
import cn.jmessage.api.user.UserGroupsResult;
import cn.jmessage.api.user.UserInfoResult;
import cn.jmessage.api.user.UserListResult;
import cn.jmessage.api.user.UserStateListResult;
import cn.jmessage.api.user.UserStateResult;
import cn.jmessage.api.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(UserClient.class);
    private String userPath;
    private String adminPath;

    public UserClient(String appkey, String masterSecret) {
        this(appkey, masterSecret, null, JMessageConfig.getInstance());
    }

    public UserClient(String appkey, String masterSecret, HttpProxy proxy) {
        this(appkey, masterSecret, proxy, JMessageConfig.getInstance());
    }

    public UserClient(String appkey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        super(appkey, masterSecret, proxy, config);
        this.userPath = (String)config.get("im.user.path");
        this.adminPath = (String)config.get("im.admin.path");
    }

    public ResponseWrapper registerUsers(RegisterPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"payload should not be null");
        return this._httpClient.sendPost(this._baseUrl + this.userPath, payload.toString());
    }

    public ResponseWrapper registerAdmins(RegisterInfo payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"payload should not be null");
        return this._httpClient.sendPost(this._baseUrl + this.adminPath, payload.toString());
    }

    public UserInfoResult getUserInfo(String username) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.userPath + "/" + username);
        return (UserInfoResult)UserInfoResult.fromResponse((ResponseWrapper)response, UserInfoResult.class);
    }

    public ResponseWrapper updateUserInfo(String username, UserPayload payload) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"payload should not be null");
        return this._httpClient.sendPut(this._baseUrl + this.userPath + "/" + username, payload.toString());
    }

    public UserStateResult getUserState(String username) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.userPath + "/" + username + "/userstat");
        return (UserStateResult)UserStateResult.fromResponse((ResponseWrapper)response, UserStateResult.class);
    }

    public UserStateListResult[] getUsersState(String ... users) throws APIConnectionException, APIRequestException {
        JsonArray jsonArray = new JsonArray();
        for (String username : users) {
            StringUtils.checkUsername(username);
            jsonArray.add((JsonElement)new JsonPrimitive(username));
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this.userPath + "/userstat", jsonArray.toString());
        return (UserStateListResult[])this._gson.fromJson(response.responseContent, UserStateListResult[].class);
    }

    public ResponseWrapper updatePassword(String username, String password) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        StringUtils.checkPassword(password);
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("new_password", password);
        return this._httpClient.sendPut(this._baseUrl + this.userPath + "/" + username + "/password", jsonObj.toString());
    }

    public ResponseWrapper deleteUser(String username) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        return this._httpClient.sendDelete(this._baseUrl + this.userPath + "/" + username);
    }

    public UserInfoResult[] getBlackList(String username) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.userPath + "/" + username + "/blacklist");
        return (UserInfoResult[])this._gson.fromJson(response.responseContent, UserInfoResult[].class);
    }

    public ResponseWrapper addBlackList(String username, String ... users) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((null != users && users.length > 0 ? 1 : 0) != 0, (Object)"black list should not be empty");
        JsonArray array = new JsonArray();
        for (String user : users) {
            array.add((JsonElement)new JsonPrimitive(user));
        }
        return this._httpClient.sendPut(this._baseUrl + this.userPath + "/" + username + "/blacklist", array.toString());
    }

    public ResponseWrapper removeBlackList(String username, String ... users) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((null != users && users.length > 0 ? 1 : 0) != 0, (Object)"black list should not be empty");
        JsonArray array = new JsonArray();
        for (String user : users) {
            array.add((JsonElement)new JsonPrimitive(user));
        }
        return this._httpClient.sendDelete(this._baseUrl + this.userPath + "/" + username + "/blacklist", array.toString());
    }

    public UserListResult getUserList(int start, int count) throws APIConnectionException, APIRequestException {
        if (start < 0 || count <= 0 || count > 500) {
            throw new IllegalArgumentException("negative index or count must more than 0 and less than 501");
        }
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.userPath + "?start=" + start + "&count=" + count);
        return (UserListResult)UserListResult.fromResponse((ResponseWrapper)response, UserListResult.class);
    }

    public UserListResult getAdminListByAppkey(int start, int count) throws APIConnectionException, APIRequestException {
        if (start < 0 || count <= 0 || count > 500) {
            throw new IllegalArgumentException("negative index or count must more than 0 and less than 501");
        }
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.adminPath + "?start=" + start + "&count=" + count);
        return (UserListResult)UserListResult.fromResponse((ResponseWrapper)response, UserListResult.class);
    }

    public ResponseWrapper setNoDisturb(String username, NoDisturbPayload payload) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"payload should not be null");
        return this._httpClient.sendPost(this._baseUrl + this.userPath + "/" + username + "/nodisturb", payload.toString());
    }

    public UserGroupsResult getGroupList(String username) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.userPath + "/" + username + "/groups");
        return UserGroupsResult.fromResponse(response);
    }

    public ResponseWrapper addFriends(String username, String ... users) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((null != users && users.length > 0 ? 1 : 0) != 0, (Object)"friend list should not be empty");
        JsonArray array = new JsonArray();
        for (String user : users) {
            array.add((JsonElement)new JsonPrimitive(user));
        }
        return this._httpClient.sendPost(this._baseUrl + this.userPath + "/" + username + "/friends", array.toString());
    }

    public ResponseWrapper deleteFriends(String username, String ... users) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((null != users && users.length > 0 ? 1 : 0) != 0, (Object)"friend list should not be empty");
        JsonArray array = new JsonArray();
        for (String user : users) {
            array.add((JsonElement)new JsonPrimitive(user));
        }
        return this._httpClient.sendDelete(this._baseUrl + this.userPath + "/" + username + "/friends", array.toString());
    }

    public ResponseWrapper updateFriendsNote(String username, FriendNote[] array) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        FriendNotePayload payload = new FriendNotePayload.Builder().setFriendNotes(array).build();
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"FriendNotePayload should not be null");
        return this._httpClient.sendPut(this._baseUrl + this.userPath + "/" + username + "/friends", payload.toString());
    }

    public UserInfoResult[] getFriendsInfo(String username) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.userPath + "/" + username + "/friends");
        return (UserInfoResult[])this._gson.fromJson(response.responseContent, UserInfoResult[].class);
    }

    public ResponseWrapper setGroupShield(GroupShieldPayload payload, String username) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"GroupShieldPayload should not be null");
        StringUtils.checkUsername(username);
        return this._httpClient.sendPost(this._baseUrl + this.userPath + "/" + username + "/groupsShield", payload.toString());
    }

    public ResponseWrapper forbidUser(String username, boolean disable) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        return this._httpClient.sendPut(this._baseUrl + this.userPath + "/" + username + "/forbidden?disable=" + disable, null);
    }
}

