/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.sensitiveword;

import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.BaseClient;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.sensitiveword.SensitiveWordListResult;
import cn.jmessage.api.sensitiveword.SensitiveWordStatusResult;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Set;

public class SensitiveWordClient
extends BaseClient {
    private String sensitiveWordPath;

    public SensitiveWordClient(String appKey, String masterSecret) {
        this(appKey, masterSecret, null, JMessageConfig.getInstance());
    }

    public SensitiveWordClient(String appkey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        super(appkey, masterSecret, proxy, config);
        this.sensitiveWordPath = (String)config.get("im.sensitive.word.path");
    }

    public ResponseWrapper addSensitiveWords(String ... words) throws APIConnectionException, APIRequestException {
        JsonArray array = new JsonArray();
        for (String word : words) {
            Preconditions.checkArgument((word.length() <= 10 ? 1 : 0) != 0, (Object)"one word's max length is 10");
            array.add((JsonElement)new JsonPrimitive(word));
        }
        return this._httpClient.sendPost(this._baseUrl + this.sensitiveWordPath, array.toString());
    }

    public ResponseWrapper addSensitiveWords(Set<String> words) throws APIConnectionException, APIRequestException {
        JsonArray array = new JsonArray();
        for (String word : words) {
            Preconditions.checkArgument((word.length() <= 10 ? 1 : 0) != 0, (Object)"one word's max length is 10");
            array.add((JsonElement)new JsonPrimitive(word));
        }
        return this._httpClient.sendPost(this._baseUrl + this.sensitiveWordPath, array.toString());
    }

    public ResponseWrapper updateSensitiveWord(String newWord, String oldWord) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((newWord.length() <= 10 ? 1 : 0) != 0, (Object)"one word's max length is 10");
        Preconditions.checkArgument((oldWord.length() <= 10 ? 1 : 0) != 0, (Object)"one word's max length is 10");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("new_word", newWord);
        jsonObject.addProperty("old_word", oldWord);
        return this._httpClient.sendPut(this._baseUrl + this.sensitiveWordPath, jsonObject.toString());
    }

    public ResponseWrapper deleteSensitiveWord(String word) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((word.length() <= 10 ? 1 : 0) != 0, (Object)"one word's max length is 10");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("word", word);
        return this._httpClient.sendDelete(this._baseUrl + this.sensitiveWordPath, jsonObject.toString());
    }

    public SensitiveWordListResult getSensitiveWordList(int start, int count) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start should not less than 0");
        Preconditions.checkArgument((count <= 2000 ? 1 : 0) != 0, (Object)"count should not bigger than 2000");
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this.sensitiveWordPath + "?start=" + start + "&count=" + count);
        return (SensitiveWordListResult)((Object)this._gson.fromJson(responseWrapper.responseContent, SensitiveWordListResult.class));
    }

    public ResponseWrapper updateSensitiveWordStatus(int status) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((status == 0 || status == 1 ? 1 : 0) != 0, (Object)"status should be 0 or 1");
        return this._httpClient.sendPut(this._baseUrl + this.sensitiveWordPath + "/status?status=" + status, null);
    }

    public SensitiveWordStatusResult getSensitiveWordStatus() throws APIConnectionException, APIRequestException {
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this.sensitiveWordPath + "/status");
        return (SensitiveWordStatusResult)((Object)this._gson.fromJson(responseWrapper.responseContent, SensitiveWordStatusResult.class));
    }
}

