/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.group;

import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jmessage.api.common.model.IModel;
import cn.jmessage.api.common.model.Members;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class GroupPayload
implements IModel {
    public static final String OWNER = "owner_username";
    public static final String GROUP_NAME = "name";
    public static final String MEMBERS = "members_username";
    public static final String DESC = "desc";
    public static final String AVATAR = "avatar";
    public static final String FLAG = "flag";
    private static Gson gson = new Gson();
    private String owner;
    private String name;
    private Members members;
    private String desc;
    private String avatar;
    private int flag = 1;

    private GroupPayload(String owner, String name, Members members, String desc, String avatar, int flag) {
        this.owner = owner;
        this.name = name;
        this.members = members;
        this.desc = desc;
        this.avatar = avatar;
        this.flag = flag;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.owner) {
            json.addProperty(OWNER, this.owner);
        }
        if (null != this.name) {
            json.addProperty(GROUP_NAME, this.name);
        }
        if (null != this.members) {
            json.add(MEMBERS, this.members.toJSON());
        }
        if (null != this.desc) {
            json.addProperty(DESC, this.desc);
        }
        if (null != this.avatar) {
            json.addProperty(AVATAR, this.avatar);
        }
        if (this.flag != 1) {
            json.addProperty(FLAG, (Number)this.flag);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String owner;
        private String name;
        private Members members;
        private String desc;
        private String avatar;
        private int flag;

        public Builder setOwner(String owner) {
            this.owner = owner.trim();
            return this;
        }

        public Builder setName(String name) {
            this.name = name.trim();
            return this;
        }

        public Builder setMembers(Members members) {
            this.members = members;
            return this;
        }

        public Builder setDesc(String desc) {
            this.desc = desc.trim();
            return this;
        }

        public Builder setAvatar(String mediaId) {
            this.avatar = mediaId;
            return this;
        }

        public Builder setFlag(int flag) {
            Preconditions.checkArgument((flag == 1 || flag == 2 ? 1 : 0) != 0, (Object)"Flag must be 1 or 2");
            this.flag = flag;
            return this;
        }

        public GroupPayload build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.owner), (Object)"The owner must not be empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.name), (Object)"The group name must not be empty.");
            Preconditions.checkArgument((!StringUtils.isLineBroken((String)this.owner) ? 1 : 0) != 0, (Object)"The owner name must not contain line feed character.");
            Preconditions.checkArgument((this.name.getBytes().length <= 64 ? 1 : 0) != 0, (Object)"The length of group name must not more than 64 bytes.");
            Preconditions.checkArgument((!StringUtils.isLineBroken((String)this.name) ? 1 : 0) != 0, (Object)"The group name must not contain line feed character.");
            if (null != this.desc) {
                Preconditions.checkArgument((this.desc.getBytes().length <= 250 ? 1 : 0) != 0, (Object)"The length of group description must not more than 250 bytes.");
            }
            return new GroupPayload(this.owner, this.name, this.members, this.desc, this.avatar, this.flag);
        }
    }
}

