/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import cn.jmessage.api.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class RegisterInfo
implements IModel {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String NICKNAME = "nickname";
    private static final String AVATAR = "avatar";
    private static final String BIRTHDAY = "birthday";
    private static final String SIGNATURE = "signature";
    private static final String GENDER = "gender";
    private static final String REGION = "region";
    private static final String ADDRESS = "address";
    private static final String EXTRAS = "extras";
    private static Gson gson = new Gson();
    private String username;
    private String password;
    private String nickname;
    private String avatar;
    private String birthday;
    private String signature;
    private int gender = -1;
    private String region;
    private String address;
    private final Map<String, String> extras;
    private final Map<String, Number> numberExtras;
    private final Map<String, Boolean> booleanExtras;
    private final Map<String, JsonObject> jsonExtras;

    private RegisterInfo(String username, String password, String nickname, String avatar, String birthday, String signature, int gender, String region, String address, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        this.username = username;
        this.password = password;
        this.nickname = nickname;
        this.avatar = avatar;
        this.birthday = birthday;
        this.signature = signature;
        this.gender = gender;
        this.region = region;
        this.address = address;
        this.extras = extras;
        this.numberExtras = numberExtras;
        this.booleanExtras = booleanExtras;
        this.jsonExtras = jsonExtras;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.username) {
            json.addProperty(USERNAME, this.username);
        }
        if (null != this.password) {
            json.addProperty(PASSWORD, this.password);
        }
        if (null != this.nickname) {
            json.addProperty(NICKNAME, this.nickname);
        }
        if (null != this.avatar) {
            json.addProperty(AVATAR, this.avatar);
        }
        if (null != this.birthday) {
            json.addProperty(BIRTHDAY, this.birthday);
        }
        if (null != this.signature) {
            json.addProperty(SIGNATURE, this.signature);
        }
        if (this.gender != -1) {
            json.addProperty(GENDER, (Number)this.gender);
        }
        if (null != this.region) {
            json.addProperty(REGION, this.region);
        }
        if (null != this.address) {
            json.addProperty(ADDRESS, this.address);
        }
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            for (String key : this.extras.keySet()) {
                if (this.extras.get(key) != null) {
                    extrasObject.add(key, (JsonElement)new JsonPrimitive(this.extras.get(key)));
                    continue;
                }
                extrasObject.add(key, (JsonElement)JsonNull.INSTANCE);
            }
        }
        if (null != this.numberExtras) {
            for (String key : this.numberExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive(this.numberExtras.get(key)));
            }
        }
        if (null != this.booleanExtras) {
            for (String key : this.booleanExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive(this.booleanExtras.get(key)));
            }
        }
        if (null != this.jsonExtras) {
            for (String key : this.jsonExtras.keySet()) {
                extrasObject.add(key, (JsonElement)this.jsonExtras.get(key));
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            json.add(EXTRAS, (JsonElement)extrasObject);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String username;
        private String password;
        private String nickname;
        private String avatar;
        private String birthday;
        private String signature;
        private int gender = -1;
        private String region;
        private String address;
        private Map<String, String> extrasBuilder;
        private Map<String, Number> numberExtrasBuilder;
        private Map<String, Boolean> booleanExtrasBuilder;
        protected Map<String, JsonObject> jsonExtrasBuilder;

        public Builder setUsername(String username) {
            this.username = username.trim();
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password.trim();
            return this;
        }

        public Builder setNickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder setAvatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder setBirthday(String birthday) {
            Preconditions.checkArgument((boolean)this.isDateFormat(birthday), (Object)"Birthday format must be yyyy-MM-dd");
            this.birthday = birthday;
            return this;
        }

        public Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public Builder setGender(int gender) {
            Preconditions.checkArgument((gender == 0 || gender == 1 || gender == 2 ? 1 : 0) != 0, (Object)"Gender must be 0, or 1, or 2");
            this.gender = gender;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap<String, Number>();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap<String, Boolean>();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, JsonObject value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.jsonExtrasBuilder) {
                this.jsonExtrasBuilder = new HashMap<String, JsonObject>();
            }
            this.jsonExtrasBuilder.put(key, value);
            return this;
        }

        public RegisterInfo build() {
            StringUtils.checkUsername(this.username);
            StringUtils.checkPassword(this.password);
            return new RegisterInfo(this.username, this.password, this.nickname, this.avatar, this.birthday, this.signature, this.gender, this.region, this.address, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder);
        }

        private boolean isDateFormat(String date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                sdf.parse(date);
                return true;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

