/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.boolex.JaninoEventEvaluator;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.net.SMTPAppenderBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPAppender
extends SMTPAppenderBase<LoggingEvent> {
    static final String DEFAULT_SUBJECT_PATTERN = "%logger{20} - %m";
    static final String DEFAULT_EVALUATOR_EXPRESSION = "level >= ERROR";
    private int bufferSize = 512;
    protected CyclicBuffer<LoggingEvent> cb = new CyclicBuffer(this.bufferSize);

    public SMTPAppender() {
    }

    public void start() {
        if (this.eventEvaluator == null) {
            JaninoEventEvaluator jee = new JaninoEventEvaluator();
            jee.setContext(this.getContext());
            jee.setExpression(DEFAULT_EVALUATOR_EXPRESSION);
            jee.setName("SMTPAppender's default event evaluator");
            jee.start();
            this.eventEvaluator = jee;
        }
        super.start();
    }

    public SMTPAppender(EventEvaluator eventEvaluator) {
        this.eventEvaluator = eventEvaluator;
    }

    protected void subAppend(LoggingEvent event) {
        event.getThreadName();
        this.cb.add((Object)event);
    }

    protected void fillBuffer(StringBuffer sbuf) {
        int len = this.cb.length();
        for (int i = 0; i < len; ++i) {
            LoggingEvent event = (LoggingEvent)this.cb.get();
            sbuf.append(this.layout.doLayout((Object)event));
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.cb.resize(bufferSize);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    protected Layout<LoggingEvent> makeSubjectLayout(String subjectStr) {
        if (subjectStr == null) {
            subjectStr = DEFAULT_SUBJECT_PATTERN;
        }
        PatternLayout pl = new PatternLayout();
        pl.setContext(this.getContext());
        pl.setPattern(subjectStr);
        pl.setPostCompileProcessor(null);
        pl.start();
        return pl;
    }
}

