/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.DiscShiftBaker1;
import umontreal.ssj.hups.Rank1Lattice;

public class DiscShiftBaker1Lattice
extends DiscShiftBaker1 {
    static final double TRENTEUN24 = 1.2916666666666667;
    static final double SEPT24 = 0.2916666666666667;

    private static double computeFactor(double x, double C1, double C2, double C3) {
        double pol3;
        double temp;
        double pol2;
        double pol1;
        if (x >= 0.5) {
            pol1 = -0.5625 + x * (3.0 - x * (4.5 - 2.0 * x));
            pol2 = -1.2916666666666667 + x * (6.0 - x * (4.0 + x * (6.0 - 5.0 * x)));
            temp = 1.0 + x * (-6.0 + 4.0 * x);
            pol3 = 0.046875 * temp * temp * (4.0 * x - 3.0);
        } else {
            pol1 = -0.0625 + x * x * (1.5 - 2.0 * x);
            pol2 = -0.2916666666666667 + x * x * (8.0 - x * (14.0 - 5.0 * x));
            temp = 1.0 + x * (2.0 - 4.0 * x);
            pol3 = -0.046875 * temp * temp * (4.0 * x - 1.0);
        }
        temp = C1 * pol1 + C2 * pol2 + C3 * pol3;
        return temp;
    }

    public DiscShiftBaker1Lattice(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscShiftBaker1Lattice(double[][] points, int n, int s, double[] gamma) {
        super(points, n, s, gamma);
    }

    public DiscShiftBaker1Lattice(int n, int s, double[] gamma) {
        super(n, s, gamma);
    }

    public DiscShiftBaker1Lattice(Rank1Lattice set) {
        super(set);
    }

    public DiscShiftBaker1Lattice() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        DiscShiftBaker1Lattice.setONES(s);
        return this.compute(points, n, s, ONES);
    }

    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        double[] C1 = new double[s];
        double[] C2 = new double[s];
        double[] C3 = new double[s];
        DiscShiftBaker1Lattice.setC(C1, C2, C3, gamma, s);
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double prod = 1.0;
            for (int r = 0; r < s; ++r) {
                double fact = DiscShiftBaker1Lattice.computeFactor(points[i][r], C1[r], C2[r], C3[r]);
                prod *= 1.0 - fact;
            }
            sum += prod;
        }
        double disc = sum / (double)n - 1.0;
        if (disc < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        return this.compute(T, n, 1.0);
    }

    @Override
    public double compute(double[] T, int n, double gamma) {
        double[] C = DiscShiftBaker1Lattice.setC(gamma);
        double C1 = C[0];
        double C2 = C[1];
        double C3 = C[2];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double h = T[i];
            double pol1 = ((h - 2.0) * h + 1.0) * h * h - 0.03333333333333333;
            double v = h - 0.5;
            if (v < 0.0) {
                v += 1.0;
            }
            double pol2 = ((v - 2.0) * v + 1.0) * v * v - 0.03333333333333333;
            double temp = C1 * (pol1 - pol2) + C2 * (7.0 * pol1 - 2.0 * pol2);
            pol1 = (((h - 3.0) * h + 2.5) * h * h - 0.5) * h * h + 0.023809523809523808;
            pol2 = (((v - 3.0) * v + 2.5) * v * v - 0.5) * v * v + 0.023809523809523808;
            sum -= (temp += C3 * (pol1 - pol2));
        }
        double disc = sum / (double)n;
        if (disc < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }
}

