/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class GlyphTable
extends TTFTable {
    public static final String TAG = "glyf";
    private GlyphData[] glyphs;
    private TTFDataStream data;
    private IndexToLocationTable loca;
    private int numGlyphs;
    protected Map<Integer, GlyphData> cache = new ConcurrentHashMap<Integer, GlyphData>();

    @Override
    public void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        this.loca = ttf.getIndexToLocation();
        this.numGlyphs = ttf.getNumberOfGlyphs();
        this.data = data;
        this.initialized = true;
    }

    private void readAll() throws IOException {
        int i;
        long[] offsets = this.loca.getOffsets();
        long endOfGlyphs = offsets[this.numGlyphs];
        long offset = this.getOffset();
        this.glyphs = new GlyphData[this.numGlyphs];
        for (i = 0; i < this.numGlyphs && (endOfGlyphs == 0L || endOfGlyphs != offsets[i]); ++i) {
            if (offsets[i + 1] <= offsets[i]) continue;
            this.glyphs[i] = new GlyphData();
            this.data.seek(offset + offsets[i]);
            this.glyphs[i].initData(this, this.data);
        }
        for (i = 0; i < this.numGlyphs; ++i) {
            GlyphData glyph = this.glyphs[i];
            if (glyph == null || !glyph.getDescription().isComposite()) continue;
            glyph.getDescription().resolve();
        }
        this.initialized = true;
    }

    public synchronized GlyphData[] getGlyphs() throws IOException {
        if (this.glyphs == null) {
            this.readAll();
        }
        return this.glyphs;
    }

    public void setGlyphs(GlyphData[] glyphsValue) {
        this.glyphs = glyphsValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlyphData getGlyph(int gid) throws IOException {
        if (gid < 0 || gid >= this.numGlyphs) {
            return null;
        }
        if (this.cache.containsKey(gid)) {
            return this.cache.get(gid);
        }
        GlyphTable glyphTable = this;
        synchronized (glyphTable) {
            GlyphData glyph;
            long currentPosition = this.data.getCurrentPosition();
            long[] offsets = this.loca.getOffsets();
            if (offsets[gid] == offsets[gid + 1]) {
                glyph = null;
            } else {
                this.data.seek(this.getOffset() + offsets[gid]);
                glyph = new GlyphData();
                glyph.initData(this, this.data);
                if (glyph.getDescription().isComposite()) {
                    glyph.getDescription().resolve();
                }
            }
            this.data.seek(currentPosition);
            return glyph;
        }
    }
}

