/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.air;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.flex.utilities.converter.BaseConverter;
import org.apache.flex.utilities.converter.Converter;
import org.apache.flex.utilities.converter.exceptions.ConverterException;
import org.apache.flex.utilities.converter.model.MavenArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirConverter
extends BaseConverter
implements Converter {
    private static final Logger LOG = LoggerFactory.getLogger(AirConverter.class);
    private String airSdkVersion;

    public AirConverter(File rootSourceDirectory, File rootTargetDirectory) throws ConverterException {
        super(rootSourceDirectory, rootTargetDirectory);
        this.airSdkVersion = this.getAirVersion(rootSourceDirectory);
    }

    protected void processDirectory() throws ConverterException {
        if (this.airSdkVersion == null || !this.rootSourceDirectory.exists() || !this.rootSourceDirectory.isDirectory()) {
            LOG.info("Skipping AIR SDK generation.");
            return;
        }
        this.generateCompilerArtifacts();
        this.generateRuntimeArtifacts();
        this.generateFrameworkArtifacts();
        this.generateTemplatesArtifact();
        this.generateMiscArtifact();
    }

    private void generateCompilerArtifacts() throws ConverterException {
        File windowsDir;
        File desktopDir;
        File iosDir;
        File androidDir;
        MavenArtifact compiler = new MavenArtifact();
        compiler.setGroupId("com.adobe.air");
        compiler.setArtifactId("compiler");
        compiler.setVersion(this.airSdkVersion);
        compiler.setPackaging("pom");
        File directory = new File(this.rootSourceDirectory, "lib");
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ConverterException("Compiler directory does not exist.");
        }
        ArrayList<File> files = new ArrayList<File>();
        File[] compilerFiles = directory.listFiles(new AirCompilerFilter());
        if (compilerFiles != null) {
            files.addAll(Arrays.asList(compilerFiles));
        }
        for (File sourceFile : files) {
            MavenArtifact artifact = this.resolveArtifact(sourceFile, "com.adobe.air.compiler", this.airSdkVersion);
            compiler.addDependency(artifact);
        }
        File binDir = new File(this.rootSourceDirectory, "bin");
        if (binDir.exists() && binDir.isDirectory()) {
            File commonZip = new File(this.rootTargetDirectory, "com.adobe.air.compiler.adt.".replace(".", File.separator) + this.airSdkVersion + File.separator + "adt-" + this.airSdkVersion + "-common.zip");
            this.generateZip(binDir, commonZip, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return "adt".equals(name) || "adt.bat".equals(name) || "adl".equals(name) || "adl.exe".equals(name);
                }
            });
        }
        if ((androidDir = new File(directory, "android")).exists() && androidDir.isDirectory()) {
            File androidZip = new File(this.rootTargetDirectory, "com.adobe.air.compiler.adt.".replace(".", File.separator) + this.airSdkVersion + File.separator + "adt-" + this.airSdkVersion + "-android.zip");
            this.generateZip(androidDir, androidZip);
        }
        if ((iosDir = new File(directory, "aot")).exists() && iosDir.isDirectory()) {
            File iosZip = new File(this.rootTargetDirectory, "com.adobe.air.compiler.adt.".replace(".", File.separator) + this.airSdkVersion + File.separator + "adt-" + this.airSdkVersion + "-ios.zip");
            this.generateZip(iosDir, iosZip);
        }
        if ((desktopDir = new File(directory, "nai")).exists() && desktopDir.isDirectory()) {
            File desktopZip = new File(this.rootTargetDirectory, "com.adobe.air.compiler.adt.".replace(".", File.separator) + this.airSdkVersion + File.separator + "adt-" + this.airSdkVersion + "-desktop.zip");
            this.generateZip(desktopDir, desktopZip);
        }
        if ((windowsDir = new File(directory, "win")).exists() && windowsDir.isDirectory()) {
            File windowsZip = new File(this.rootTargetDirectory, "com.adobe.air.compiler.adt.".replace(".", File.separator) + this.airSdkVersion + File.separator + "adt-" + this.airSdkVersion + "-win.zip");
            this.generateZip(windowsDir, windowsZip);
        }
        this.writeArtifact(compiler);
    }

    private void generateRuntimeArtifacts() throws ConverterException {
        MavenArtifact runtime = new MavenArtifact();
        runtime.setGroupId("com.adobe.air");
        runtime.setArtifactId("runtime");
        runtime.setVersion(this.airSdkVersion);
        runtime.setPackaging("pom");
        MavenArtifact adl = new MavenArtifact();
        adl.setGroupId("com.adobe.air.runtime");
        adl.setArtifactId("adl");
        adl.setVersion(this.airSdkVersion);
        adl.setPackaging("pom");
        File directory = new File(this.rootSourceDirectory, "bin");
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ConverterException("Runtime directory does not exist.");
        }
        File[] adlExecutables = directory.listFiles(new AirRuntimeFilter());
        if (adlExecutables != null) {
            for (File adlExecutable : adlExecutables) {
                if (adlExecutable.getName().endsWith(".exe")) {
                    adl.addBinaryArtifact("win", adlExecutable);
                    continue;
                }
                adl.addBinaryArtifact("mac", adlExecutable);
            }
        }
        runtime.addDependency(adl);
        this.writeArtifact(adl);
        List<MavenArtifact> airRuntimeArtifacts = this.generateAirRuntimeArtifacts(this.rootSourceDirectory);
        if (airRuntimeArtifacts != null) {
            for (MavenArtifact airRuntimeArtifact : airRuntimeArtifacts) {
                runtime.addDependency(airRuntimeArtifact);
            }
        }
        this.writeArtifact(runtime);
    }

    private void generateFrameworkArtifacts() throws ConverterException {
        MavenArtifact framework = new MavenArtifact();
        framework.setGroupId("com.adobe.air");
        framework.setArtifactId("framework");
        framework.setVersion(this.airSdkVersion);
        framework.setPackaging("pom");
        File directory = new File(this.rootSourceDirectory, "frameworks" + File.separator + "libs" + File.separator + "air");
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ConverterException("Framework directory does not exist.");
        }
        ArrayList<File> files = new ArrayList<File>();
        File[] frameworkFiles = directory.listFiles(new AirFrameworkFilter());
        if (frameworkFiles != null) {
            files.addAll(Arrays.asList(frameworkFiles));
        }
        for (File sourceFile : files) {
            MavenArtifact artifact = this.resolveArtifact(sourceFile, "com.adobe.air.framework", this.airSdkVersion);
            framework.addDependency(artifact);
        }
        this.writeArtifact(framework);
    }

    private void generateTemplatesArtifact() throws ConverterException {
        MavenArtifact templates = new MavenArtifact();
        templates.setGroupId("com.adobe.air");
        templates.setArtifactId("templates");
        templates.setVersion(this.airSdkVersion);
        templates.setPackaging("jar");
        File templatesDir = new File(this.rootSourceDirectory, "templates");
        File[] directories = templatesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && ("air".equals(pathname.getName()) || "extensions".equals(pathname.getName()) || "sdk".equals(pathname.getName()));
            }
        });
        try {
            File jar = File.createTempFile("air-templates-" + this.airSdkVersion, "jar");
            this.generateZip(directories, jar);
            templates.addDefaultBinaryArtifact(jar);
        }
        catch (IOException e) {
            throw new ConverterException("Error creating runtime zip.", (Throwable)e);
        }
        this.writeArtifact(templates);
    }

    private void generateMiscArtifact() throws ConverterException {
        MavenArtifact misc = new MavenArtifact();
        misc.setGroupId("com.adobe.air");
        misc.setArtifactId("misc");
        misc.setVersion(this.airSdkVersion);
        misc.setPackaging("zip");
        Collection content = this.listAllFiles(this.rootSourceDirectory, new AirMiscFilter(this.rootSourceDirectory));
        try {
            File zip = File.createTempFile("air-misc-" + this.airSdkVersion, "jar");
            this.generateZip(this.rootSourceDirectory, content.toArray(new File[0]), zip);
            misc.addDefaultBinaryArtifact(zip);
        }
        catch (IOException e) {
            throw new ConverterException("Error creating misc zip.", (Throwable)e);
        }
        this.writeArtifact(misc);
    }

    private void generateZip(File inputDir, File outputFile) throws ConverterException {
        this.generateZip(inputDir, outputFile, null);
    }

    private void generateZip(File inputDir, File outputFile, FilenameFilter filter) throws ConverterException {
        try {
            File[] zipfiles;
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(outputFile));
            File[] fileArray = zipfiles = filter != null ? inputDir.listFiles(filter) : inputDir.listFiles();
            if (zipfiles != null) {
                for (File file : zipfiles) {
                    this.addFileToZip(zipOutputStream, file, this.rootSourceDirectory);
                }
            }
            zipOutputStream.close();
        }
        catch (IOException e) {
            throw new ConverterException("Error generating android package zip.", (Throwable)e);
        }
    }

    private List<MavenArtifact> generateAirRuntimeArtifacts(File rootDirectory) throws ConverterException {
        LinkedList<MavenArtifact> airRuntimeArtifacts = new LinkedList<MavenArtifact>();
        File runtimeRoot = new File(rootDirectory, "runtimes");
        File[] runtimes = runtimeRoot.listFiles();
        if (runtimes != null) {
            for (File runtime : runtimes) {
                MavenArtifact airRuntimeArtifact = new MavenArtifact();
                airRuntimeArtifact.setGroupId("com.adobe.air.runtime");
                airRuntimeArtifact.setArtifactId(runtime.getName());
                airRuntimeArtifact.setVersion(this.airSdkVersion);
                airRuntimeArtifact.setPackaging("pom");
                File[] platforms = runtime.listFiles();
                if (platforms != null) {
                    for (File platform : platforms) {
                        if (!platform.isDirectory()) continue;
                        String platformName = platform.getName();
                        try {
                            File zip = File.createTempFile("AirRuntime-" + platformName + "-" + this.airSdkVersion, "zip");
                            this.generateZip(platform.listFiles(), zip);
                            airRuntimeArtifact.addBinaryArtifact(platformName, zip);
                        }
                        catch (IOException e) {
                            throw new ConverterException("Error creating runtime zip.", (Throwable)e);
                        }
                    }
                } else {
                    return null;
                }
                this.writeArtifact(airRuntimeArtifact);
                airRuntimeArtifacts.add(airRuntimeArtifact);
            }
        }
        return airRuntimeArtifacts;
    }

    private String getAirVersion(File rootDirectory) throws ConverterException {
        File sdkDescriptor = new File(rootDirectory, "AIR SDK Readme.txt");
        if (!sdkDescriptor.exists() || !sdkDescriptor.isFile()) {
            return null;
        }
        FilterInputStream in = null;
        FileInputStream descriptorInputStream = null;
        try {
            descriptorInputStream = new FileInputStream(sdkDescriptor);
            in = new DataInputStream(descriptorInputStream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = br.readLine();
            String string = strLine.substring("Adobe AIR ".length(), strLine.indexOf(" ", "Adobe AIR ".length()));
            return string;
        }
        catch (Exception e) {
            throw new ConverterException("Error getting AIR version.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (descriptorInputStream != null) {
                try {
                    descriptorInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        AirConverter converter = new AirConverter(new File(args[0]), new File(args[1]));
        converter.convert();
    }

    private static class AirMiscFilter
    implements FileFilter {
        private File rootSourceDirectory;

        AirMiscFilter(File rootSourceDirectory) {
            this.rootSourceDirectory = rootSourceDirectory;
        }

        @Override
        public boolean accept(File pathname) {
            boolean result;
            String relativePath = pathname.getAbsolutePath().substring(this.rootSourceDirectory.getAbsolutePath().length());
            boolean bl = result = "/AIR SDK license.pdf".equals(relativePath) || "\\AIR SDK license.pdf".equals(relativePath) || "/AIR SDK Readme.txt".equals(relativePath) || "\\AIR SDK Readme.txt".equals(relativePath) || "/airsdk.xml".equals(relativePath) || "\\airsdk.xml".equals(relativePath) || relativePath.startsWith("/frameworks/projects/air/") || relativePath.startsWith("\\frameworks\\projects\\air\\") || relativePath.startsWith("/include/") || relativePath.startsWith("\\include\\") || relativePath.startsWith("/install/") || relativePath.startsWith("\\install\\") || relativePath.startsWith("/samples/") || relativePath.startsWith("\\samples\\");
            if (relativePath.startsWith("/frameworks/libs/air/") || relativePath.startsWith("\\frameworks\\libs\\air\\")) {
                result = !pathname.getName().endsWith(".swc") && !pathname.getName().endsWith(".swf");
            }
            LOG.debug(relativePath + " = " + result);
            return result;
        }
    }

    private static class AirRuntimeFilter
    implements FilenameFilter {
        private AirRuntimeFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase("adl.exe") || name.equalsIgnoreCase("adl");
        }
    }

    public static class AirFrameworkFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.equals("aircore.swc") || name.equals("airglobal.swc") || name.equals("applicationupdater.swc") || name.equals("applicationupdater_ui.swc") || name.equals("servicemonitor.swc") || name.equals("crosspromotion.swc") || name.equals("gamepad.swc");
        }
    }

    public static class AirCompilerFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.equals("adt.jar") || name.equals("smali.jar") || name.equals("baksmali.jar");
        }
    }
}

