/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Collection;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.OnCamelContextEvent;
import org.apache.camel.spi.OnCamelContextInitialized;
import org.apache.camel.spi.OnCamelContextStart;
import org.apache.camel.spi.OnCamelContextStop;

public abstract class LifecycleStrategySupport
implements LifecycleStrategy {
    public void onContextStart(CamelContext context) throws VetoCamelContextStartException {
    }

    public void onContextStop(CamelContext context) {
    }

    public void onComponentAdd(String name, Component component) {
    }

    public void onComponentRemove(String name, Component component) {
    }

    public void onEndpointAdd(Endpoint endpoint) {
    }

    public void onEndpointRemove(Endpoint endpoint) {
    }

    public void onServiceAdd(CamelContext context, Service service, Route route) {
    }

    public void onServiceRemove(CamelContext context, Service service, Route route) {
    }

    public void onRoutesAdd(Collection<Route> routes) {
    }

    public void onRoutesRemove(Collection<Route> routes) {
    }

    public void onRouteContextCreate(Route route) {
    }

    public void onErrorHandlerAdd(Route route, Processor errorHandler, ErrorHandlerFactory errorHandlerBuilder) {
    }

    public void onErrorHandlerRemove(Route route, Processor errorHandler, ErrorHandlerFactory errorHandlerBuilder) {
    }

    public void onThreadPoolAdd(CamelContext camelContext, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
    }

    public void onThreadPoolRemove(CamelContext camelContext, ThreadPoolExecutor threadPool) {
    }

    public static LifecycleStrategy adapt(final OnCamelContextEvent handler) {
        return new LifecycleStrategySupport(){

            public void onContextInitialized(CamelContext context) throws VetoCamelContextStartException {
                if (handler instanceof OnCamelContextInitialized) {
                    ((OnCamelContextInitialized)handler).onContextInitialized(context);
                }
            }

            @Override
            public void onContextStart(CamelContext context) throws VetoCamelContextStartException {
                if (handler instanceof OnCamelContextStart) {
                    ((OnCamelContextStart)handler).onContextStart(context);
                }
            }

            @Override
            public void onContextStop(CamelContext context) {
                if (handler instanceof OnCamelContextStop) {
                    ((OnCamelContextStop)handler).onContextStop(context);
                }
            }
        };
    }

    public static LifecycleStrategy adapt(final OnCamelContextInitialized handler) {
        return new LifecycleStrategySupport(){

            public void onContextInitialized(CamelContext context) throws VetoCamelContextStartException {
                handler.onContextInitialized(context);
            }
        };
    }

    public static LifecycleStrategy adapt(final OnCamelContextStart handler) {
        return new LifecycleStrategySupport(){

            @Override
            public void onContextStart(CamelContext context) throws VetoCamelContextStartException {
                handler.onContextStart(context);
            }
        };
    }

    public static LifecycleStrategy adapt(final OnCamelContextStop handler) {
        return new LifecycleStrategySupport(){

            @Override
            public void onContextStop(CamelContext context) {
                handler.onContextStop(context);
            }
        };
    }

    public static OnCamelContextInitialized onCamelContextInitialized(Consumer<CamelContext> consumer) {
        return consumer::accept;
    }

    public static OnCamelContextStart onCamelContextStart(Consumer<CamelContext> consumer) {
        return consumer::accept;
    }

    public static OnCamelContextStop onCamelContextStop(Consumer<CamelContext> consumer) {
        return consumer::accept;
    }
}

