/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.maven.packaging.PropertyConfigurerGenerator;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.util.ReflectionHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

@Mojo(name="generate-configurer", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateConfigurerMojo
extends AbstractGeneratorMojo {
    public static final DotName CONFIGURER = DotName.createSimple((String)"org.apache.camel.spi.Configurer");
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;
    @Parameter(defaultValue="true")
    protected boolean discoverClasses = true;
    @Parameter
    protected List<String> classes;
    @Component
    private ArtifactFactory artifactFactory;
    private DynamicClassLoader projectClassLoader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        this.addRelevantProjectDependenciesToClasspath(urls);
        this.projectClassLoader = DynamicClassLoader.createDynamicClassLoaderFromUrls(urls);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (this.discoverClasses) {
            Index index;
            Path output = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
            try (InputStream is = Files.newInputStream(output.resolve("META-INF/jandex.idx"), new OpenOption[0]);){
                index = new IndexReader(is).read();
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
            }
            List annotations = index.getAnnotations(CONFIGURER);
            annotations.stream().filter(annotation -> annotation.target().kind() == AnnotationTarget.Kind.CLASS).filter(annotation -> annotation.target().asClass().nestingType() == ClassInfo.NestingType.TOP_LEVEL).filter(annotation -> GenerateConfigurerMojo.asBooleanDefaultTrue(annotation, "generateConfigurer")).forEach(annotation -> {
                String currentClass = annotation.target().asClass().name().toString();
                set.add(currentClass);
            });
        }
        if (this.classes != null && !this.classes.isEmpty()) {
            set.addAll(this.classes);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Generating configuers for the following classes: " + set));
        }
        for (String fqn : set) {
            try {
                String targetFqn = fqn;
                int pos = fqn.indexOf(61);
                if (pos != -1) {
                    targetFqn = fqn.substring(pos + 1);
                    fqn = fqn.substring(0, pos);
                }
                List<Option> options = this.processClass(fqn);
                this.generateConfigurer(fqn, targetFqn, options);
                this.generateMetaInfConfigurer(targetFqn);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error processing class: " + fqn, e);
            }
        }
    }

    private void addRelevantProjectDependenciesToClasspath(List<URL> path) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Project Dependencies will be included.");
            URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
            this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
            path.add(mainClasses);
            Set dependencies = this.project.getArtifacts();
            dependencies.addAll(this.getAllNonTestScopedDependencies());
            for (Artifact classPathElement : dependencies) {
                this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                File file = classPathElement.getFile();
                if (file == null) continue;
                path.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private Collection<Artifact> getAllNonTestScopedDependencies() throws MojoExecutionException {
        ArrayList<Artifact> answer = new ArrayList<Artifact>();
        for (Artifact artifact : this.getAllDependencies()) {
            if (artifact.getScope().equals("test")) continue;
            answer.add(artifact);
        }
        return answer;
    }

    private Collection<Artifact> getAllDependencies() throws MojoExecutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Dependency dependency : this.project.getDependencies()) {
            VersionRange versionRange;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            try {
                versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("unable to parse version", (Exception)((Object)e));
            }
            String type = dependency.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dependency.getClassifier();
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            if (this.artifactFactory == null) continue;
            Artifact art = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
            if (scope.equalsIgnoreCase("system")) {
                art.setFile(new File(dependency.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion exclusion : dependency.getExclusions()) {
                exclusions.add(exclusion.getGroupId() + ":" + exclusion.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            art.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(art);
        }
        return artifacts;
    }

    private List<Option> processClass(String fqn) throws ClassNotFoundException {
        ArrayList<Option> answer = new ArrayList<Option>();
        HashSet names = new HashSet();
        Class<?> clazz = this.projectClassLoader.loadClass(fqn);
        ReflectionHelper.doWithMethods(clazz, m -> {
            boolean setter = m.getName().length() >= 4 && m.getName().startsWith("set") && Character.isUpperCase(m.getName().charAt(3));
            setter &= Modifier.isPublic(m.getModifiers()) && m.getParameterCount() == 1;
            if (setter &= this.filterSetter(m)) {
                String t;
                String getter = "get" + Character.toUpperCase(m.getName().charAt(3)) + m.getName().substring(4);
                Class<?> type = m.getParameterTypes()[0];
                if (Boolean.TYPE == type || Boolean.class == type) {
                    try {
                        String isGetter = "is" + getter.substring(3);
                        clazz.getMethod(isGetter, null);
                        getter = isGetter;
                    }
                    catch (Exception isGetter) {
                        // empty catch block
                    }
                }
                if (names.add(t = Character.toUpperCase(m.getName().charAt(3)) + m.getName().substring(4))) {
                    answer.add(new Option(t, type, getter));
                } else {
                    boolean replace = false;
                    Field field = ReflectionHelper.findField((Class)clazz, (String)(Character.toLowerCase(t.charAt(0)) + t.substring(1)));
                    if (field != null && field.getType().equals(type)) {
                        replace = true;
                    }
                    if (replace) {
                        answer.removeIf(o -> o.getName().equals(t));
                        answer.add(new Option(t, type, getter));
                    }
                }
            }
        });
        return answer;
    }

    private boolean filterSetter(Method setter) {
        if ("setBindingMode".equals(setter.getName())) {
            return setter.getParameterTypes()[0] == String.class;
        }
        if ("setHostNameResolver".equals(setter.getName())) {
            return setter.getParameterTypes()[0] == String.class;
        }
        return true;
    }

    private void generateConfigurer(String fqn, String targetFqn, List<Option> options) throws IOException {
        int pos = targetFqn.lastIndexOf(46);
        String pn = targetFqn.substring(0, pos);
        String cn = targetFqn.substring(pos + 1) + "Configurer";
        String en = fqn;
        String pfqn = fqn;
        String psn = "org.apache.camel.support.component.PropertyConfigurerSupport";
        StringWriter sw = new StringWriter();
        PropertyConfigurerGenerator.generatePropertyConfigurer(pn, cn, en, pfqn, psn, false, false, options, sw);
        String source = sw.toString();
        String fileName = pn.replace('.', '/') + "/" + cn + ".java";
        this.sourcesOutputDir.mkdirs();
        boolean updated = this.updateResource(this.sourcesOutputDir.toPath(), fileName, source);
        if (updated) {
            this.getLog().info((CharSequence)("Updated " + fileName));
        }
    }

    private void generateMetaInfConfigurer(String name) {
        int pos = name.lastIndexOf(46);
        String pn = name.substring(0, pos);
        String en = name.substring(pos + 1);
        try (StringWriter w = new StringWriter();){
            ((Writer)w).append("# Generated by camel build tools - do NOT edit this file!\n");
            ((Writer)w).append("class=").append(pn).append(".").append(en).append("Configurer").append("\n");
            this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/configurer/" + en, ((Object)w).toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean asBooleanDefaultTrue(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av == null || av.asBoolean();
    }

    private static class Option
    extends BaseOptionModel {
        public Option(String name, Class type, String getter) {
            this.setName(name);
            if (byte[].class == type) {
                this.setJavaType("byte[]");
            } else if (long[].class == type) {
                this.setJavaType("long[]");
            } else if (type.isArray()) {
                String arrType = Strings.between((String)type.getName(), (String)"[L", (String)";") + "[]";
                this.setJavaType(arrType);
            } else {
                this.setJavaType(type.getName());
            }
            this.setGetterMethod(getter);
        }
    }
}

