/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IHistoryTyped;
import ca.uhn.fhir.rest.gclient.IHistoryUntyped;
import java.util.Date;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class FhirHistory {
    private final IGenericClient client;

    public FhirHistory(IGenericClient client) {
        this.client = client;
    }

    public <T extends IBaseBundle> T onServer(Class<T> returnType, Integer count, Date cutoff, IPrimitiveType<Date> iCutoff, Map<ExtraParameters, Object> extraParameters) {
        IHistoryTyped tiHistoryTyped = ((IHistoryUntyped)this.client.history().onServer()).andReturnBundle(returnType);
        this.processOptionalParams(count, cutoff, iCutoff, tiHistoryTyped);
        ExtraParameters.process(extraParameters, tiHistoryTyped);
        return (T)((IBaseBundle)tiHistoryTyped.execute());
    }

    public <T extends IBaseBundle> T onType(Class<IBaseResource> resourceType, Class<T> returnType, Integer count, Date cutoff, IPrimitiveType<Date> iCutoff, Map<ExtraParameters, Object> extraParameters) {
        IHistoryTyped tiHistoryTyped = ((IHistoryUntyped)this.client.history().onType(resourceType)).andReturnBundle(returnType);
        this.processOptionalParams(count, cutoff, iCutoff, tiHistoryTyped);
        ExtraParameters.process(extraParameters, tiHistoryTyped);
        return (T)((IBaseBundle)tiHistoryTyped.execute());
    }

    public <T extends IBaseBundle> T onInstance(IIdType id, Class<T> returnType, Integer count, Date cutoff, IPrimitiveType<Date> iCutoff, Map<ExtraParameters, Object> extraParameters) {
        IHistoryTyped tiHistoryTyped = ((IHistoryUntyped)this.client.history().onInstance(id)).andReturnBundle(returnType);
        this.processOptionalParams(count, cutoff, iCutoff, tiHistoryTyped);
        ExtraParameters.process(extraParameters, tiHistoryTyped);
        return (T)((IBaseBundle)tiHistoryTyped.execute());
    }

    private <T extends IBaseBundle> void processOptionalParams(Integer count, Date theCutoff, IPrimitiveType<Date> cutoff, IHistoryTyped<T> tiHistoryTyped) {
        if (count != null) {
            tiHistoryTyped.count(count);
        }
        if (theCutoff != null) {
            tiHistoryTyped.since(theCutoff);
        }
        if (cutoff != null) {
            tiHistoryTyped.since(cutoff);
        }
    }
}

