/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.List;
import java.util.Map;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.xmlsecurity.XmlSignerComponent;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration;

public interface XmlsecuritySignComponentBuilderFactory {
    public static XmlsecuritySignComponentBuilder xmlsecuritySign() {
        return new XmlsecuritySignComponentBuilderImpl();
    }

    public static class XmlsecuritySignComponentBuilderImpl
    extends AbstractComponentBuilder<XmlSignerComponent>
    implements XmlsecuritySignComponentBuilder {
        @Override
        protected XmlSignerComponent buildConcreteComponent() {
            return new XmlSignerComponent();
        }

        private XmlSignerConfiguration getOrCreateConfiguration(XmlSignerComponent component) {
            if (component.getSignerConfiguration() == null) {
                component.setSignerConfiguration(new XmlSignerConfiguration());
            }
            return component.getSignerConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "addKeyInfoReference": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setAddKeyInfoReference((Boolean)value);
                    return true;
                }
                case "baseUri": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setBaseUri((String)value);
                    return true;
                }
                case "canonicalizationMethod": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setCanonicalizationMethod((AlgorithmMethod)value);
                    return true;
                }
                case "clearHeaders": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setClearHeaders((Boolean)value);
                    return true;
                }
                case "contentObjectId": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setContentObjectId((String)value);
                    return true;
                }
                case "contentReferenceType": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setContentReferenceType((String)value);
                    return true;
                }
                case "contentReferenceUri": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setContentReferenceUri((String)value);
                    return true;
                }
                case "cryptoContextProperties": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setCryptoContextProperties((Map)value);
                    return true;
                }
                case "digestAlgorithm": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setDigestAlgorithm((String)value);
                    return true;
                }
                case "disallowDoctypeDecl": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setDisallowDoctypeDecl((Boolean)value);
                    return true;
                }
                case "keyAccessor": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setKeyAccessor((KeyAccessor)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((XmlSignerComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "omitXmlDeclaration": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setOmitXmlDeclaration((Boolean)value);
                    return true;
                }
                case "outputXmlEncoding": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setOutputXmlEncoding((String)value);
                    return true;
                }
                case "parentLocalName": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setParentLocalName((String)value);
                    return true;
                }
                case "parentNamespace": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setParentNamespace((String)value);
                    return true;
                }
                case "parentXpath": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setParentXpath((XPathFilterParameterSpec)value);
                    return true;
                }
                case "plainText": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setPlainText((Boolean)value);
                    return true;
                }
                case "plainTextEncoding": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setPlainTextEncoding((String)value);
                    return true;
                }
                case "prefixForXmlSignatureNamespace": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setPrefixForXmlSignatureNamespace((String)value);
                    return true;
                }
                case "properties": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setProperties((XmlSignatureProperties)value);
                    return true;
                }
                case "schemaResourceUri": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setSchemaResourceUri((String)value);
                    return true;
                }
                case "signatureAlgorithm": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setSignatureAlgorithm((String)value);
                    return true;
                }
                case "signatureId": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setSignatureId((String)value);
                    return true;
                }
                case "transformMethods": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setTransformMethods((List)value);
                    return true;
                }
                case "xpathsToIdAttributes": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setXpathsToIdAttributes((List)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((XmlSignerComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "signerConfiguration": {
                    ((XmlSignerComponent)component).setSignerConfiguration((XmlSignerConfiguration)value);
                    return true;
                }
                case "uriDereferencer": {
                    this.getOrCreateConfiguration((XmlSignerComponent)component).setUriDereferencer((URIDereferencer)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface XmlsecuritySignComponentBuilder
    extends ComponentBuilder<XmlSignerComponent> {
        default public XmlsecuritySignComponentBuilder addKeyInfoReference(Boolean addKeyInfoReference) {
            this.doSetProperty("addKeyInfoReference", addKeyInfoReference);
            return this;
        }

        default public XmlsecuritySignComponentBuilder baseUri(String baseUri) {
            this.doSetProperty("baseUri", baseUri);
            return this;
        }

        default public XmlsecuritySignComponentBuilder canonicalizationMethod(AlgorithmMethod canonicalizationMethod) {
            this.doSetProperty("canonicalizationMethod", canonicalizationMethod);
            return this;
        }

        default public XmlsecuritySignComponentBuilder clearHeaders(Boolean clearHeaders) {
            this.doSetProperty("clearHeaders", clearHeaders);
            return this;
        }

        default public XmlsecuritySignComponentBuilder contentObjectId(String contentObjectId) {
            this.doSetProperty("contentObjectId", contentObjectId);
            return this;
        }

        default public XmlsecuritySignComponentBuilder contentReferenceType(String contentReferenceType) {
            this.doSetProperty("contentReferenceType", contentReferenceType);
            return this;
        }

        default public XmlsecuritySignComponentBuilder contentReferenceUri(String contentReferenceUri) {
            this.doSetProperty("contentReferenceUri", contentReferenceUri);
            return this;
        }

        default public XmlsecuritySignComponentBuilder cryptoContextProperties(Map<String, Object> cryptoContextProperties) {
            this.doSetProperty("cryptoContextProperties", cryptoContextProperties);
            return this;
        }

        default public XmlsecuritySignComponentBuilder digestAlgorithm(String digestAlgorithm) {
            this.doSetProperty("digestAlgorithm", digestAlgorithm);
            return this;
        }

        default public XmlsecuritySignComponentBuilder disallowDoctypeDecl(Boolean disallowDoctypeDecl) {
            this.doSetProperty("disallowDoctypeDecl", disallowDoctypeDecl);
            return this;
        }

        default public XmlsecuritySignComponentBuilder keyAccessor(KeyAccessor keyAccessor) {
            this.doSetProperty("keyAccessor", keyAccessor);
            return this;
        }

        default public XmlsecuritySignComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public XmlsecuritySignComponentBuilder omitXmlDeclaration(Boolean omitXmlDeclaration) {
            this.doSetProperty("omitXmlDeclaration", omitXmlDeclaration);
            return this;
        }

        default public XmlsecuritySignComponentBuilder outputXmlEncoding(String outputXmlEncoding) {
            this.doSetProperty("outputXmlEncoding", outputXmlEncoding);
            return this;
        }

        default public XmlsecuritySignComponentBuilder parentLocalName(String parentLocalName) {
            this.doSetProperty("parentLocalName", parentLocalName);
            return this;
        }

        default public XmlsecuritySignComponentBuilder parentNamespace(String parentNamespace) {
            this.doSetProperty("parentNamespace", parentNamespace);
            return this;
        }

        default public XmlsecuritySignComponentBuilder parentXpath(XPathFilterParameterSpec parentXpath) {
            this.doSetProperty("parentXpath", parentXpath);
            return this;
        }

        default public XmlsecuritySignComponentBuilder plainText(Boolean plainText) {
            this.doSetProperty("plainText", plainText);
            return this;
        }

        default public XmlsecuritySignComponentBuilder plainTextEncoding(String plainTextEncoding) {
            this.doSetProperty("plainTextEncoding", plainTextEncoding);
            return this;
        }

        default public XmlsecuritySignComponentBuilder prefixForXmlSignatureNamespace(String prefixForXmlSignatureNamespace) {
            this.doSetProperty("prefixForXmlSignatureNamespace", prefixForXmlSignatureNamespace);
            return this;
        }

        default public XmlsecuritySignComponentBuilder properties(XmlSignatureProperties properties) {
            this.doSetProperty("properties", properties);
            return this;
        }

        default public XmlsecuritySignComponentBuilder schemaResourceUri(String schemaResourceUri) {
            this.doSetProperty("schemaResourceUri", schemaResourceUri);
            return this;
        }

        default public XmlsecuritySignComponentBuilder signatureAlgorithm(String signatureAlgorithm) {
            this.doSetProperty("signatureAlgorithm", signatureAlgorithm);
            return this;
        }

        default public XmlsecuritySignComponentBuilder signatureId(String signatureId) {
            this.doSetProperty("signatureId", signatureId);
            return this;
        }

        default public XmlsecuritySignComponentBuilder transformMethods(List<AlgorithmMethod> transformMethods) {
            this.doSetProperty("transformMethods", transformMethods);
            return this;
        }

        default public XmlsecuritySignComponentBuilder xpathsToIdAttributes(List<XPathFilterParameterSpec> xpathsToIdAttributes) {
            this.doSetProperty("xpathsToIdAttributes", xpathsToIdAttributes);
            return this;
        }

        default public XmlsecuritySignComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public XmlsecuritySignComponentBuilder signerConfiguration(XmlSignerConfiguration signerConfiguration) {
            this.doSetProperty("signerConfiguration", signerConfiguration);
            return this;
        }

        default public XmlsecuritySignComponentBuilder uriDereferencer(URIDereferencer uriDereferencer) {
            this.doSetProperty("uriDereferencer", uriDereferencer);
            return this;
        }
    }
}

