/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.calendar.GoogleCalendarClientFactory;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamComponent;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration;

public interface GoogleCalendarStreamComponentBuilderFactory {
    public static GoogleCalendarStreamComponentBuilder googleCalendarStream() {
        return new GoogleCalendarStreamComponentBuilderImpl();
    }

    public static class GoogleCalendarStreamComponentBuilderImpl
    extends AbstractComponentBuilder<GoogleCalendarStreamComponent>
    implements GoogleCalendarStreamComponentBuilder {
        @Override
        protected GoogleCalendarStreamComponent buildConcreteComponent() {
            return new GoogleCalendarStreamComponent();
        }

        private GoogleCalendarStreamConfiguration getOrCreateConfiguration(GoogleCalendarStreamComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new GoogleCalendarStreamConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessToken": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "applicationName": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setApplicationName((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((GoogleCalendarStreamComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "calendarId": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setCalendarId((String)value);
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setClientId((String)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "considerLastUpdate": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setConsiderLastUpdate(((Boolean)value).booleanValue());
                    return true;
                }
                case "consumeFromNow": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setConsumeFromNow(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxResults": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setMaxResults(((Integer)value).intValue());
                    return true;
                }
                case "query": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setQuery((String)value);
                    return true;
                }
                case "refreshToken": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setRefreshToken((String)value);
                    return true;
                }
                case "scopes": {
                    this.getOrCreateConfiguration((GoogleCalendarStreamComponent)component).setScopes((List)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((GoogleCalendarStreamComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientFactory": {
                    ((GoogleCalendarStreamComponent)component).setClientFactory((GoogleCalendarClientFactory)value);
                    return true;
                }
                case "configuration": {
                    ((GoogleCalendarStreamComponent)component).setConfiguration((GoogleCalendarStreamConfiguration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface GoogleCalendarStreamComponentBuilder
    extends ComponentBuilder<GoogleCalendarStreamComponent> {
        default public GoogleCalendarStreamComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder applicationName(String applicationName) {
            this.doSetProperty("applicationName", applicationName);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder calendarId(String calendarId) {
            this.doSetProperty("calendarId", calendarId);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder considerLastUpdate(boolean considerLastUpdate) {
            this.doSetProperty("considerLastUpdate", considerLastUpdate);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder consumeFromNow(boolean consumeFromNow) {
            this.doSetProperty("consumeFromNow", consumeFromNow);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder maxResults(int maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder query(String query) {
            this.doSetProperty("query", query);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder refreshToken(String refreshToken) {
            this.doSetProperty("refreshToken", refreshToken);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder scopes(List<String> scopes) {
            this.doSetProperty("scopes", scopes);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder clientFactory(GoogleCalendarClientFactory clientFactory) {
            this.doSetProperty("clientFactory", clientFactory);
            return this;
        }

        default public GoogleCalendarStreamComponentBuilder configuration(GoogleCalendarStreamConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

