/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ehcache.EhcacheComponent;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;

public interface EhcacheComponentBuilderFactory {
    public static EhcacheComponentBuilder ehcache() {
        return new EhcacheComponentBuilderImpl();
    }

    public static class EhcacheComponentBuilderImpl
    extends AbstractComponentBuilder<EhcacheComponent>
    implements EhcacheComponentBuilder {
        @Override
        protected EhcacheComponent buildConcreteComponent() {
            return new EhcacheComponent();
        }

        private EhcacheConfiguration getOrCreateConfiguration(EhcacheComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new EhcacheConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "cacheManager": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setCacheManager((CacheManager)value);
                    return true;
                }
                case "cacheManagerConfiguration": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setCacheManagerConfiguration((Configuration)value);
                    return true;
                }
                case "configurationUri": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "createCacheIfNotExist": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setCreateCacheIfNotExist(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((EhcacheComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "eventFiring": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setEventFiring((EventFiring)value);
                    return true;
                }
                case "eventOrdering": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setEventOrdering((EventOrdering)value);
                    return true;
                }
                case "eventTypes": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setEventTypes((String)value);
                    return true;
                }
                case "action": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setAction((String)value);
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setKey(value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((EhcacheComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((EhcacheComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setConfiguration((CacheConfiguration)value);
                    return true;
                }
                case "configurations": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setConfigurations((Map)value);
                    return true;
                }
                case "keyType": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setKeyType((String)value);
                    return true;
                }
                case "valueType": {
                    this.getOrCreateConfiguration((EhcacheComponent)component).setValueType((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface EhcacheComponentBuilder
    extends ComponentBuilder<EhcacheComponent> {
        default public EhcacheComponentBuilder cacheManager(CacheManager cacheManager) {
            this.doSetProperty("cacheManager", cacheManager);
            return this;
        }

        default public EhcacheComponentBuilder cacheManagerConfiguration(Configuration cacheManagerConfiguration) {
            this.doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }

        default public EhcacheComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public EhcacheComponentBuilder createCacheIfNotExist(boolean createCacheIfNotExist) {
            this.doSetProperty("createCacheIfNotExist", createCacheIfNotExist);
            return this;
        }

        default public EhcacheComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public EhcacheComponentBuilder eventFiring(EventFiring eventFiring) {
            this.doSetProperty("eventFiring", eventFiring);
            return this;
        }

        default public EhcacheComponentBuilder eventOrdering(EventOrdering eventOrdering) {
            this.doSetProperty("eventOrdering", eventOrdering);
            return this;
        }

        default public EhcacheComponentBuilder eventTypes(String eventTypes) {
            this.doSetProperty("eventTypes", eventTypes);
            return this;
        }

        default public EhcacheComponentBuilder action(String action) {
            this.doSetProperty("action", action);
            return this;
        }

        default public EhcacheComponentBuilder key(Object key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public EhcacheComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public EhcacheComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public EhcacheComponentBuilder configuration(CacheConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public EhcacheComponentBuilder configurations(Map<String, CacheConfiguration> configurations) {
            this.doSetProperty("configurations", configurations);
            return this;
        }

        default public EhcacheComponentBuilder keyType(String keyType) {
            this.doSetProperty("keyType", keyType);
            return this;
        }

        default public EhcacheComponentBuilder valueType(String valueType) {
            this.doSetProperty("valueType", valueType);
            return this;
        }
    }
}

