/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.box.sdk.EncryptionAlgorithm;
import com.box.sdk.IAccessTokenCache;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.box.BoxComponent;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface BoxComponentBuilderFactory {
    public static BoxComponentBuilder box() {
        return new BoxComponentBuilderImpl();
    }

    public static class BoxComponentBuilderImpl
    extends AbstractComponentBuilder<BoxComponent>
    implements BoxComponentBuilder {
        @Override
        protected BoxComponent buildConcreteComponent() {
            return new BoxComponent();
        }

        private BoxConfiguration getOrCreateConfiguration(BoxComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new BoxConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "clientId": {
                    this.getOrCreateConfiguration((BoxComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((BoxComponent)component).setConfiguration((BoxConfiguration)value);
                    return true;
                }
                case "enterpriseId": {
                    this.getOrCreateConfiguration((BoxComponent)component).setEnterpriseId((String)value);
                    return true;
                }
                case "userId": {
                    this.getOrCreateConfiguration((BoxComponent)component).setUserId((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((BoxComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((BoxComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((BoxComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpParams": {
                    this.getOrCreateConfiguration((BoxComponent)component).setHttpParams((Map)value);
                    return true;
                }
                case "authenticationType": {
                    this.getOrCreateConfiguration((BoxComponent)component).setAuthenticationType((String)value);
                    return true;
                }
                case "accessTokenCache": {
                    this.getOrCreateConfiguration((BoxComponent)component).setAccessTokenCache((IAccessTokenCache)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((BoxComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "encryptionAlgorithm": {
                    this.getOrCreateConfiguration((BoxComponent)component).setEncryptionAlgorithm((EncryptionAlgorithm)value);
                    return true;
                }
                case "maxCacheEntries": {
                    this.getOrCreateConfiguration((BoxComponent)component).setMaxCacheEntries(((Integer)value).intValue());
                    return true;
                }
                case "privateKeyFile": {
                    this.getOrCreateConfiguration((BoxComponent)component).setPrivateKeyFile((String)value);
                    return true;
                }
                case "privateKeyPassword": {
                    this.getOrCreateConfiguration((BoxComponent)component).setPrivateKeyPassword((String)value);
                    return true;
                }
                case "publicKeyId": {
                    this.getOrCreateConfiguration((BoxComponent)component).setPublicKeyId((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((BoxComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "userName": {
                    this.getOrCreateConfiguration((BoxComponent)component).setUserName((String)value);
                    return true;
                }
                case "userPassword": {
                    this.getOrCreateConfiguration((BoxComponent)component).setUserPassword((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface BoxComponentBuilder
    extends ComponentBuilder<BoxComponent> {
        default public BoxComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public BoxComponentBuilder configuration(BoxConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public BoxComponentBuilder enterpriseId(String enterpriseId) {
            this.doSetProperty("enterpriseId", enterpriseId);
            return this;
        }

        default public BoxComponentBuilder userId(String userId) {
            this.doSetProperty("userId", userId);
            return this;
        }

        default public BoxComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public BoxComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public BoxComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public BoxComponentBuilder httpParams(Map<String, Object> httpParams) {
            this.doSetProperty("httpParams", httpParams);
            return this;
        }

        default public BoxComponentBuilder authenticationType(String authenticationType) {
            this.doSetProperty("authenticationType", authenticationType);
            return this;
        }

        default public BoxComponentBuilder accessTokenCache(IAccessTokenCache accessTokenCache) {
            this.doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }

        default public BoxComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public BoxComponentBuilder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }

        default public BoxComponentBuilder maxCacheEntries(int maxCacheEntries) {
            this.doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }

        default public BoxComponentBuilder privateKeyFile(String privateKeyFile) {
            this.doSetProperty("privateKeyFile", privateKeyFile);
            return this;
        }

        default public BoxComponentBuilder privateKeyPassword(String privateKeyPassword) {
            this.doSetProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }

        default public BoxComponentBuilder publicKeyId(String publicKeyId) {
            this.doSetProperty("publicKeyId", publicKeyId);
            return this;
        }

        default public BoxComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public BoxComponentBuilder userName(String userName) {
            this.doSetProperty("userName", userName);
            return this;
        }

        default public BoxComponentBuilder userPassword(String userPassword) {
            this.doSetProperty("userPassword", userPassword);
            return this;
        }
    }
}

