/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteTemplateParameterBuilder;
import org.apache.camel.TypeConverter;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.impl.engine.BaseExecutorServiceManager;
import org.apache.camel.impl.engine.BaseServiceResolver;
import org.apache.camel.impl.engine.DefaultAsyncProcessorAwaitManager;
import org.apache.camel.impl.engine.DefaultBeanIntrospection;
import org.apache.camel.impl.engine.DefaultCamelBeanPostProcessor;
import org.apache.camel.impl.engine.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.impl.engine.DefaultComponentNameResolver;
import org.apache.camel.impl.engine.DefaultComponentResolver;
import org.apache.camel.impl.engine.DefaultConfigurerResolver;
import org.apache.camel.impl.engine.DefaultDataFormatResolver;
import org.apache.camel.impl.engine.DefaultEndpointRegistry;
import org.apache.camel.impl.engine.DefaultFactoryFinderResolver;
import org.apache.camel.impl.engine.DefaultHeadersMapFactory;
import org.apache.camel.impl.engine.DefaultInflightRepository;
import org.apache.camel.impl.engine.DefaultInjector;
import org.apache.camel.impl.engine.DefaultLanguageResolver;
import org.apache.camel.impl.engine.DefaultManagementNameStrategy;
import org.apache.camel.impl.engine.DefaultMessageHistoryFactory;
import org.apache.camel.impl.engine.DefaultNodeIdFactory;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.impl.engine.DefaultPackageScanResourceResolver;
import org.apache.camel.impl.engine.DefaultProcessorFactory;
import org.apache.camel.impl.engine.DefaultReactiveExecutor;
import org.apache.camel.impl.engine.DefaultRouteController;
import org.apache.camel.impl.engine.DefaultShutdownStrategy;
import org.apache.camel.impl.engine.DefaultStreamCachingStrategy;
import org.apache.camel.impl.engine.DefaultTracer;
import org.apache.camel.impl.engine.DefaultTransformerRegistry;
import org.apache.camel.impl.engine.DefaultUnitOfWorkFactory;
import org.apache.camel.impl.engine.DefaultUuidGenerator;
import org.apache.camel.impl.engine.DefaultValidatorRegistry;
import org.apache.camel.impl.engine.EndpointKey;
import org.apache.camel.impl.engine.WebSpherePackageScanClassResolver;
import org.apache.camel.impl.transformer.TransformerKey;
import org.apache.camel.impl.validator.ValidatorKey;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentNameResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RestBindingJaxbDataFormatFactory;
import org.apache.camel.spi.RestRegistryFactory;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.spi.XMLRoutesDefinitionLoader;
import org.apache.camel.support.DefaultRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCamelContext
extends AbstractCamelContext {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCamelContext.class);

    public SimpleCamelContext() {
        this(true);
    }

    public SimpleCamelContext(boolean init) {
        super(init);
    }

    @Override
    protected HealthCheckRegistry createHealthCheckRegistry() {
        return new BaseServiceResolver<HealthCheckRegistry>("health-check-registry", HealthCheckRegistry.class).resolve(this.getCamelContextReference()).orElse(null);
    }

    @Override
    protected TypeConverter createTypeConverter() {
        return new DefaultTypeConverter(this.getCamelContextReference(), this.getPackageScanClassResolver(), this.getInjector(), this.getDefaultFactoryFinder(), this.isLoadTypeConverters());
    }

    @Override
    protected TypeConverterRegistry createTypeConverterRegistry() {
        TypeConverter typeConverter = this.getTypeConverter();
        if (typeConverter == null) {
            typeConverter = this.createTypeConverter();
        }
        if (typeConverter instanceof TypeConverterRegistry) {
            return (TypeConverterRegistry)typeConverter;
        }
        return null;
    }

    @Override
    protected Injector createInjector() {
        FactoryFinder finder = this.getDefaultFactoryFinder();
        return finder.newInstance("Injector", Injector.class).orElse(new DefaultInjector(this.getCamelContextReference()));
    }

    @Override
    protected PropertiesComponent createPropertiesComponent() {
        return new BaseServiceResolver<PropertiesComponent>("properties-component-factory", PropertiesComponent.class).resolve(this.getCamelContextReference()).orElseGet(org.apache.camel.component.properties.PropertiesComponent::new);
    }

    @Override
    protected CamelBeanPostProcessor createBeanPostProcessor() {
        return new DefaultCamelBeanPostProcessor(this.getCamelContextReference());
    }

    @Override
    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    @Override
    protected ComponentNameResolver createComponentNameResolver() {
        return new DefaultComponentNameResolver();
    }

    @Override
    protected Registry createRegistry() {
        return new DefaultRegistry();
    }

    @Override
    protected UuidGenerator createUuidGenerator() {
        return new DefaultUuidGenerator();
    }

    @Override
    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        return new BaseServiceResolver<ModelJAXBContextFactory>("model-jaxbcontext-factory", ModelJAXBContextFactory.class).resolve(this.getCamelContextReference()).orElseThrow(() -> new IllegalArgumentException("Cannot find ModelJAXBContextFactory on classpath. Add camel-xml-jaxb to classpath."));
    }

    @Override
    protected NodeIdFactory createNodeIdFactory() {
        return new DefaultNodeIdFactory();
    }

    @Override
    protected FactoryFinderResolver createFactoryFinderResolver() {
        return new DefaultFactoryFinderResolver();
    }

    @Override
    protected ClassResolver createClassResolver() {
        return new DefaultClassResolver(this.getCamelContextReference());
    }

    @Override
    protected ProcessorFactory createProcessorFactory() {
        return new DefaultProcessorFactory();
    }

    @Override
    protected DataFormatResolver createDataFormatResolver() {
        return new DefaultDataFormatResolver();
    }

    @Override
    protected MessageHistoryFactory createMessageHistoryFactory() {
        return new DefaultMessageHistoryFactory();
    }

    @Override
    protected InflightRepository createInflightRepository() {
        return new DefaultInflightRepository();
    }

    @Override
    protected AsyncProcessorAwaitManager createAsyncProcessorAwaitManager() {
        return new DefaultAsyncProcessorAwaitManager();
    }

    @Override
    protected RouteController createRouteController() {
        return new DefaultRouteController(this.getCamelContextReference());
    }

    @Override
    protected ShutdownStrategy createShutdownStrategy() {
        return new DefaultShutdownStrategy(this.getCamelContextReference());
    }

    @Override
    protected PackageScanClassResolver createPackageScanClassResolver() {
        DefaultPackageScanClassResolver packageScanClassResolver;
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(((Object)((Object)this)).getClass().getClassLoader())) {
            LOG.info("Using WebSphere specific PackageScanClassResolver");
            packageScanClassResolver = new WebSpherePackageScanClassResolver("META-INF/services/org/apache/camel/TypeConverter");
        } else {
            packageScanClassResolver = new DefaultPackageScanClassResolver();
        }
        return packageScanClassResolver;
    }

    @Override
    protected PackageScanResourceResolver createPackageScanResourceResolver() {
        return new DefaultPackageScanResourceResolver();
    }

    @Override
    protected UnitOfWorkFactory createUnitOfWorkFactory() {
        return new DefaultUnitOfWorkFactory();
    }

    @Override
    protected RuntimeCamelCatalog createRuntimeCamelCatalog() {
        return new BaseServiceResolver<RuntimeCamelCatalog>("runtime-camelcatalog", RuntimeCamelCatalog.class).resolve(this.getCamelContextReference()).orElseThrow(() -> new IllegalArgumentException("Cannot find RuntimeCamelCatalog on classpath. Add camel-core-catalog to classpath."));
    }

    @Override
    protected CamelContextNameStrategy createCamelContextNameStrategy() {
        return new DefaultCamelContextNameStrategy();
    }

    @Override
    protected ManagementNameStrategy createManagementNameStrategy() {
        return new DefaultManagementNameStrategy(this.getCamelContextReference());
    }

    @Override
    protected HeadersMapFactory createHeadersMapFactory() {
        return new BaseServiceResolver<HeadersMapFactory>("headers-map-factory", HeadersMapFactory.class).resolve(this.getCamelContextReference()).orElseGet(DefaultHeadersMapFactory::new);
    }

    @Override
    protected BeanProxyFactory createBeanProxyFactory() {
        return new BaseServiceResolver<BeanProxyFactory>("bean-proxy-factory", BeanProxyFactory.class).resolve(this.getCamelContextReference()).orElseThrow(() -> new IllegalArgumentException("Cannot find BeanProxyFactory on classpath. Add camel-bean to classpath."));
    }

    @Override
    protected BeanProcessorFactory createBeanProcessorFactory() {
        return new BaseServiceResolver<BeanProcessorFactory>("bean-processor-factory", BeanProcessorFactory.class).resolve(this.getCamelContextReference()).orElseThrow(() -> new IllegalArgumentException("Cannot find BeanProcessorFactory on classpath. Add camel-bean to classpath."));
    }

    @Override
    protected BeanIntrospection createBeanIntrospection() {
        return new DefaultBeanIntrospection();
    }

    @Override
    protected XMLRoutesDefinitionLoader createXMLRoutesDefinitionLoader() {
        return new BaseServiceResolver<XMLRoutesDefinitionLoader>("xmlroutes-loader", XMLRoutesDefinitionLoader.class).resolve(this.getCamelContextReference()).orElseThrow(() -> new IllegalArgumentException("Cannot find XMLRoutesDefinitionLoader on classpath. Add either camel-xml-io or camel-xml-jaxb to classpath."));
    }

    @Override
    protected ModelToXMLDumper createModelToXMLDumper() {
        return new BaseServiceResolver<ModelToXMLDumper>("modelxml-dumper", ModelToXMLDumper.class).resolve(this.getCamelContextReference()).orElseThrow(() -> new IllegalArgumentException("Cannot find ModelToXMLDumper on classpath. Add camel-xml-jaxb to classpath."));
    }

    @Override
    protected RestBindingJaxbDataFormatFactory createRestBindingJaxbDataFormatFactory() {
        return new BaseServiceResolver<RestBindingJaxbDataFormatFactory>("rest-binding-jaxb-dataformat-factory", RestBindingJaxbDataFormatFactory.class).resolve(this.getCamelContextReference()).orElseThrow(() -> new IllegalArgumentException("Cannot find RestBindingJaxbDataFormatFactory on classpath. Add camel-jaxb to classpath."));
    }

    @Override
    protected Tracer createTracer() {
        Map map;
        Tracer tracer = null;
        if (this.getRegistry() != null && (map = this.getRegistry().findByTypeWithName(Tracer.class)).size() == 1) {
            tracer = (Tracer)map.values().iterator().next();
        }
        if (tracer == null) {
            tracer = this.getExtension(Tracer.class);
        }
        if (tracer == null) {
            tracer = new DefaultTracer();
            this.setExtension(Tracer.class, tracer);
        }
        return tracer;
    }

    @Override
    protected LanguageResolver createLanguageResolver() {
        return new DefaultLanguageResolver();
    }

    @Override
    protected ConfigurerResolver createConfigurerResolver() {
        return new DefaultConfigurerResolver();
    }

    @Override
    protected RestRegistryFactory createRestRegistryFactory() {
        return new BaseServiceResolver<RestRegistryFactory>("rest-registry-factory", RestRegistryFactory.class).resolve(this.getCamelContextReference()).orElseThrow(() -> new IllegalArgumentException("Cannot find RestRegistryFactory on classpath. Add camel-rest to classpath."));
    }

    @Override
    protected EndpointRegistry<EndpointKey> createEndpointRegistry(Map<EndpointKey, Endpoint> endpoints) {
        return new DefaultEndpointRegistry(this.getCamelContextReference(), endpoints);
    }

    @Override
    protected StreamCachingStrategy createStreamCachingStrategy() {
        return new DefaultStreamCachingStrategy();
    }

    @Override
    protected ReactiveExecutor createReactiveExecutor() {
        return new BaseServiceResolver<ReactiveExecutor>("reactive-executor", ReactiveExecutor.class).resolve(this.getCamelContextReference()).orElseGet(DefaultReactiveExecutor::new);
    }

    public AsyncProcessor createMulticast(Collection<Processor> processors, ExecutorService executor, boolean shutdownExecutorService) {
        return new MulticastProcessor(this.getCamelContextReference(), null, processors, null, true, executor, shutdownExecutorService, false, false, 0L, null, false, false);
    }

    @Override
    protected ValidatorRegistry<ValidatorKey> createValidatorRegistry() {
        return new DefaultValidatorRegistry(this.getCamelContextReference());
    }

    @Override
    protected TransformerRegistry<TransformerKey> createTransformerRegistry() {
        return new DefaultTransformerRegistry(this.getCamelContextReference());
    }

    @Override
    protected ExecutorServiceManager createExecutorServiceManager() {
        return new BaseExecutorServiceManager(this.getCamelContextReference());
    }

    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public RouteTemplateParameterBuilder addRouteFromTemplate(String routeTemplateId) {
        return new RouteTemplateParameterBuilder((CamelContext)this, routeTemplateId);
    }
}

