/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.struts.component;

import com.opensymphony.xwork2.util.ValueStack;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.views.annotations.StrutsTag;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.struts.Option;
import org.nuiton.wikitty.struts.TagUseException;
import org.nuiton.wikitty.struts.WikittyFieldHandler;
import org.nuiton.wikitty.struts.component.AbstractWikittyComponentBean;

@StrutsTag(name="wikittyselect", tldTagClass="org.nuiton.wikitty.struts.tag.SelectCriteriaTag", description="", allowDynamicAttributes=false)
public class SelectCriteriaBean
extends AbstractWikittyComponentBean {
    private static final Log log = LogFactory.getLog(SelectCriteriaBean.class);
    public static final String OPEN_TEMPLATE = "ws-selectcriteria";
    protected Criteria criteria;
    protected String descField;

    public SelectCriteriaBean(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    @Override
    protected void evaluateExtraParams() {
        super.evaluateExtraParams();
        String[] fieldsAccess = StringUtil.split((String)this.fqFieldName, (String)".");
        this.addParameter("value", this.getWikitty().getFieldAsString(fieldsAccess[0], fieldsAccess[1]));
        LinkedList<Option> fixlist = new LinkedList<Option>();
        WikittyProxy proxy = this.getProxy();
        if (proxy == null) {
            throw new TagUseException("Tag must declare a valid proxy attribute if used outside ws:form tag");
        }
        PagedResult wikitties = proxy.findAllByCriteria(this.criteria);
        String[] descriptor = StringUtil.split((String)this.descField, (String)WikittyFieldHandler.FIELD_SEPARATOR);
        if (wikitties != null) {
            for (Wikitty wiki : wikitties) {
                String val = wiki.getId();
                String desc = wiki.getId();
                if (descriptor.length != 0) {
                    desc = "";
                    for (String descriptorIt : descriptor) {
                        String[] descTable = StringUtil.split((String)descriptorIt, (String)".");
                        desc = desc + wiki.getFieldAsWikitty(descTable[0], descTable[1]);
                    }
                }
                fixlist.add(new Option(val, desc));
            }
            this.addParameter("wikittiesvalues", fixlist);
        }
    }

    public String getDefaultOpenTemplate() {
        return OPEN_TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return "ws-empty";
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public String getDescField() {
        return this.descField;
    }

    public void setDescField(String descfield) {
        this.descField = descfield;
    }
}

