package org.nuiton.wikitty.entities;

/*
 * #%L
 * Wikitty :: dto
 * %%
 * Copyright (C) 2010 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyException;

@Generated(value = "org.nuiton.wikitty.generator.WikittyDTOGenerator", date = "Tue Jul 21 11:13:45 CEST 2015")
public class WikittyI18nDTO implements WikittyI18n {

    @WikittyField(fqn = "WikittyI18n.translatableValues")
    protected Set<String> translatableValues = new LinkedHashSet<String>();

    @WikittyField(fqn = "WikittyI18n.lang")
    protected Set<String> lang = new LinkedHashSet<String>();

    @WikittyField(fqn = "WikittyI18n.translations")
    protected String translations;

    protected String wikittyId;

    protected int modificationCount = 0;

    protected String wikittyVersion;

    @Override
    public Set<String> getTranslatableValues() {
        return translatableValues;
}

    @Override
    public void setTranslatableValues(Set<String> translatableValues) {
        if (translatableValues == null){
            this.translatableValues = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.translatableValues=new LinkedHashSet<String>(translatableValues);
        }
        modificationCount++;
}

    @Override
    public void addAllTranslatableValues(Collection<String> translatableValues) {
        if (this.translatableValues == null){
            this.translatableValues = new LinkedHashSet<String>();
        }
        this.translatableValues.addAll(translatableValues);
        modificationCount++;
}

    @Override
    public void addTranslatableValues(String... element) {
        if (this.translatableValues == null){
            this.translatableValues = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.translatableValues.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeTranslatableValues(String... element) {
        if (this.translatableValues != null) {
            for (String v : element) {
                translatableValues.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearTranslatableValues() {
        if (this.translatableValues != null) {
            translatableValues.clear();
            modificationCount++;
        }
}

    @Override
    public Set<String> getLang() {
        return lang;
}

    @Override
    public void setLang(Set<String> lang) {
        if (lang == null){
            this.lang = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.lang=new LinkedHashSet<String>(lang);
        }
        modificationCount++;
}

    @Override
    public void addAllLang(Collection<String> lang) {
        if (this.lang == null){
            this.lang = new LinkedHashSet<String>();
        }
        this.lang.addAll(lang);
        modificationCount++;
}

    @Override
    public void addLang(String... element) {
        if (this.lang == null){
            this.lang = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.lang.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeLang(String... element) {
        if (this.lang != null) {
            for (String v : element) {
                lang.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearLang() {
        if (this.lang != null) {
            lang.clear();
            modificationCount++;
        }
}

    @Override
    public String getTranslations() {
        return translations;
}

    @Override
    public void setTranslations(String translations) {
        this.translations=translations;
        modificationCount++;
}

    public WikittyI18nDTO() {
}

    public WikittyI18nDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getStaticExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getFieldAsObject(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyI18n)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyI18n sourceCopy = (WikittyI18n)source;

        Set<String> translatableValues = sourceCopy.getTranslatableValues();
        if (translatableValues != null){
            setTranslatableValues(new LinkedHashSet<String>(translatableValues));
        }

        Set<String> lang = sourceCopy.getLang();
        if (lang != null){
            setLang(new LinkedHashSet<String>(lang));
        }

        setTranslations(sourceCopy.getTranslations());

        setWikittyVersion(sourceCopy.getWikittyVersion());
}

    @Override
    public String getTranslation(String lang, String field) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void setTranslation(String lang, String field, String trad) {
        throw new UnsupportedOperationException("Not supported yet.");
}

} //WikittyI18nDTO
