/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.api;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.api.InMemorySearchTest;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.operators.Like;

public abstract class AbstractSearchTest {
    protected static final Log log = LogFactory.getLog(AbstractSearchTest.class);
    public static final String EXT_PRODUCT = "Product";
    public static final String EXT_CATEGORY = "Category";
    public static final String PRODUCT_PRICE = "price";
    public static final String PRODUCT_NAME = "name";
    public static final String PRODUCT_CATEGORY = "category";
    public static final String PRODUCT_COLOR = "colors";
    public static final String CATEGORY_NAME = "name";
    public static final String VERSION = "3.0";
    public static String W_ID = "";
    protected WikittyProxy proxy = new WikittyProxy(this.getWikittyService());

    @Before
    public void initData() {
        WikittyExtension product = ExtensionFactory.create((String)EXT_PRODUCT, (String)VERSION).addField(PRODUCT_PRICE, FieldType.TYPE.NUMERIC).addField("name", FieldType.TYPE.STRING).addField(PRODUCT_CATEGORY, FieldType.TYPE.WIKITTY).addField(PRODUCT_COLOR, FieldType.TYPE.STRING).maxOccur(Integer.MAX_VALUE).extension();
        this.proxy.storeExtension(product);
        WikittyExtension category = ExtensionFactory.create((String)EXT_CATEGORY, (String)VERSION).addField("name", FieldType.TYPE.STRING).extension();
        this.proxy.storeExtension(category);
        WikittyImpl category1 = new WikittyImpl();
        category1.addExtension(category);
        category1.setField(EXT_CATEGORY, "name", (Object)"HardWare");
        this.proxy.store((Wikitty)category1);
        WikittyImpl category2 = new WikittyImpl();
        category2.addExtension(category);
        category2.setField(EXT_CATEGORY, "name", (Object)"Wrong category");
        this.proxy.store((Wikitty)category2);
        WikittyImpl product1 = new WikittyImpl();
        product1.addExtension(product);
        product1.setField(EXT_PRODUCT, "name", (Object)"Paint");
        product1.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)20);
        product1.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category1.getId());
        ArrayList<String> colors1 = new ArrayList<String>();
        colors1.add("Blue");
        colors1.add("Black");
        product1.setField(EXT_PRODUCT, PRODUCT_COLOR, colors1);
        this.proxy.store((Wikitty)product1);
        WikittyImpl product2 = new WikittyImpl();
        product2.addExtension(product);
        product2.setField(EXT_PRODUCT, "name", (Object)"Screwdriver");
        product2.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)3);
        product2.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category2.getId());
        ArrayList<String> colors2 = new ArrayList<String>();
        colors2.add("Red");
        colors2.add("Black");
        product2.setField(EXT_PRODUCT, PRODUCT_COLOR, colors2);
        this.proxy.store((Wikitty)product2);
        WikittyImpl product3 = new WikittyImpl();
        product3.addExtension(product);
        product3.setField(EXT_PRODUCT, "name", (Object)"Paint Blue");
        product3.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)22);
        product3.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category2.getId());
        ArrayList<String> colors3 = new ArrayList<String>();
        colors3.add("Blue");
        product3.setField(EXT_PRODUCT, PRODUCT_COLOR, colors3);
        this.proxy.store((Wikitty)product3);
        W_ID = product3.getId();
    }

    protected void assumeNotYetImplementedInMemory() {
        boolean isInMomory = this instanceof InMemorySearchTest;
        if (isInMomory) {
            log.warn((Object)"Not yet implemented in memory, skipping");
        }
        Assume.assumeTrue((!isInMomory ? 1 : 0) != 0);
    }

    @Test
    public void testEq() throws Exception {
        Search query = Search.query().eq("Product.price", "3");
        Criteria eqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(eqCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        Search query2 = Search.query().eq("Product.name", "*dri*");
        Criteria eqCriteria2 = query2.criteria();
        PagedResult results2 = this.proxy.findAllByCriteria(eqCriteria2);
        Assert.assertEquals((long)1L, (long)results2.getAll().size());
        Wikitty resultW2 = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW2.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW2.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        Search query3 = Search.query().eq("Product.name", "*dri?er");
        Criteria eqCriteria3 = query3.criteria();
        PagedResult results3 = this.proxy.findAllByCriteria(eqCriteria3);
        Assert.assertEquals((long)1L, (long)results3.getAll().size());
        Wikitty resultW3 = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW3.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW3.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testNeq() throws Exception {
        Search query = Search.query().neq("Product.price", "3");
        Criteria neqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(neqCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Test
    public void testBw() throws Exception {
        Search query = Search.query().bw("Product.price", "3", "5");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testLt() throws Exception {
        Search query = Search.query().lt("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testLe() throws Exception {
        Search query = Search.query().le("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testGt() throws Exception {
        Search query = Search.query().gt("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint Blue", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)22L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testGe() throws Exception {
        Search query = Search.query().ge("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testContains() throws Exception {
        Search query = Search.query().contains("Product.price", "3", new String[0]);
        Criteria inCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(inCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testIn() throws Exception {
        Search query = Search.query().in("Product.price", "1", new String[]{"2", "3", "4", "5"});
        Criteria inCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(inCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testExteq() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT);
        Criteria exteqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(exteqCriteria);
        Assert.assertEquals((long)3L, (long)results.getAll().size());
    }

    @Test
    public void testExtneq() throws Exception {
        Search query = Search.query().extneq(EXT_PRODUCT);
        Criteria extneqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(extneqCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testIdeq() throws Exception {
        Search query = Search.query().ideq(W_ID);
        Criteria ideqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ideqCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint Blue", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)22L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testIdneq() throws Exception {
        Search query = Search.query().idneq(W_ID);
        Criteria idneqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(idneqCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Test
    public void testUnlike() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().unlike("Product.name", "*dri*");
        Criteria likeCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(likeCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Test
    public void testLike() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().like("Product.name", "*dri*");
        Criteria likeCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(likeCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
    }

    @Test
    public void testSw() throws Exception {
        Search query = Search.query().sw("Product.name", "Scre");
        Criteria swCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(swCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testNsw() throws Exception {
        Search query = Search.query().nsw("Product.name", "Scre");
        Criteria nswCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(nswCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Test
    public void testEw() throws Exception {
        Search query = Search.query().ew("Product.name", "ver");
        Criteria ewCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ewCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testNotew() throws Exception {
        Search query = Search.query().notew("Product.name", "ver");
        Criteria notewCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(notewCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Test
    public void testKeyword() throws Exception {
        Search query = Search.query().keyword("Paint");
        Criteria keywordCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(keywordCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testIsNull() throws Exception {
        Search query = Search.query().isNull("Product.name");
        Criteria isNull = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(isNull);
        Assert.assertEquals((long)0L, (long)results.getAll().size());
    }

    @Test
    public void testIsNotNull() throws Exception {
        Search query = Search.query().isNotNull("Product.name");
        Criteria isNotNull = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(isNotNull);
        Assert.assertEquals((long)3L, (long)results.getAll().size());
    }

    @Test
    public void testFalse() throws Exception {
        Search query = Search.query().rFalse();
        Criteria rFalse = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(rFalse);
        Assert.assertEquals((long)0L, (long)results.getAll().size());
    }

    @Test
    public void testTrue() throws Exception {
        Search query = Search.query().rTrue();
        Criteria rTrue = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(rTrue);
        Assert.assertEquals((long)5L, (long)results.getAll().size());
    }

    @Test
    public void testAnd() throws Exception {
        Search query = Search.query().and().bw("Product.price", "15", "25").sw("Product.name", "Paint");
        Criteria andCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(andCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testOr() throws Exception {
        Search query = Search.query();
        query.or().gt("Product.price", "20").sw("Product.name", "Screw");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testNot() throws Exception {
        Search query = Search.query();
        query.not().ge("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)3L, (long)results.getAll().size());
    }

    @Test
    public void testAssociated() throws Exception {
        Search query = Search.query().bw("Product.price", "15", "25").sw("Product.name", "Paint").associated("Product.category").eq("Category.name", "HardWare");
        Criteria associatedCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(associatedCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)20L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        query = Search.query().bw("Product.price", "15", "25").sw("Product.name", "Paint").associated("Product.category").eq("Category.name", "don't return anything");
        associatedCriteria = query.criteria();
        results = this.proxy.findAllByCriteria(associatedCriteria);
        Assert.assertEquals((long)0L, (long)results.getAll().size());
    }

    @Test
    public void testSearchAllEquals() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().eq("Category.name", "HardWare").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().eq("*.name", "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().eq("Category.name." + FieldType.TYPE.STRING, "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().eq("*.name." + FieldType.TYPE.STRING, "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
    }

    @Test
    public void testSearchAllContains() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().contains("Product.colors", "Red", new String[0]).criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().contains("*.colors", "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().contains("Product.colors." + FieldType.TYPE.STRING, "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().contains("*.colors." + FieldType.TYPE.STRING, "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
    }

    @Test
    public void testSearchAllLike() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().like("Product.name", "*Blue").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().like("*.name", "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().like("Product.name." + FieldType.TYPE.STRING, "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().like("*.name." + FieldType.TYPE.STRING, "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
    }

    @Test
    public void testSearchAllLowerCase() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().eq("Category.name", "HardWare").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().eq("Category.name", "hardware").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)0L, (long)pagedResult.size());
        criteria = Search.query().like("Category.name", "HardWare", Like.SearchAs.ToLowerCase).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().like("Category.name", "hardware", Like.SearchAs.ToLowerCase).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().like("Category.name", "HardWare", Like.SearchAs.AsText).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
        criteria = Search.query().like("Category.name", "hardware", Like.SearchAs.AsText).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.size());
    }

    @Test
    public void testSearchWithSort() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().like("*.name", "*").criteria();
        criteria.setSortAscending(new String[]{"*.name"});
        try {
            this.proxy.findAllByCriteria(criteria);
        }
        catch (Exception eee) {
            eee.printStackTrace();
            Assert.fail();
        }
        String sortableExtName = "sortable";
        String numFieldName = "num";
        WikittyExtension sortable = ExtensionFactory.create((String)sortableExtName, (String)"1.0").addField(numFieldName, FieldType.TYPE.NUMERIC).extension();
        this.proxy.storeExtension(sortable);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(10);
        expected.add(1);
        expected.add(7);
        for (Integer i : expected) {
            WikittyImpl w = new WikittyImpl();
            w.addExtension(sortable);
            w.setField(sortableExtName, numFieldName, (Object)i);
            this.proxy.store((Wikitty)w);
        }
        Collections.sort(expected);
        Criteria criteria2 = Search.query().eq(Element.ELT_EXTENSION, sortableExtName).criteria();
        criteria2.setSortAscending(new String[]{WikittyUtil.getFQFieldName((String)sortableExtName, (String)numFieldName)});
        PagedResult result = this.proxy.findAllByCriteria(criteria2);
        ArrayList<Integer> resulted = new ArrayList<Integer>();
        for (Wikitty w : result) {
            resulted.add(w.getFieldAsInt(sortableExtName, numFieldName));
        }
        Assert.assertEquals(expected, resulted);
    }

    @Test
    public void testComplexQueries() throws Exception {
    }

    public abstract WikittyService getWikittyService();
}

