/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: InMemorySearchTest.java 805 2011-04-13 16:59:23Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.1.1/wikitty-api/src/test/java/org/nuiton/wikitty/api/InMemorySearchTest.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.api;

import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.services.WikittyServiceInMemory;

/**
 * User: couteau
 * Date: 05/04/11
 */
public class InMemorySearchTest extends AbstractSearchTest {

    WikittyService service;

    @Override
    public WikittyService getWikittyService() {

        if (service == null) {
            ApplicationConfig config = WikittyConfig.getConfig();
            service = new WikittyServiceInMemory(config);
        }

        return service;
    }
}
