/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class WikittyHookAbstract extends BusinessEntityImpl implements WikittyHook {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyHook;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = WikittyHookHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        WikittyHookHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_NAME, oldValue, getName());
}

    /**
     * getActionToHook :
     * @return Set<String> 
     */

    @Override
    public Set<String> getActionToHook() {
        Set<String> result = WikittyHookHelper.getActionToHook(getWikitty());
        return result;
}

    /**
     * setActionToHook :
     * @param actionToHook 
     */

    @Override
    public void setActionToHook(Set<String> actionToHook) {
        Set<String> oldValue = getActionToHook();
        WikittyHookHelper.setActionToHook(getWikitty(), actionToHook);
        getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, oldValue, getActionToHook());
}

    /**
     * addAllActionToHook :
     * @param actionToHook 
     */

    @Override
    public void addAllActionToHook(Set<String> actionToHook) {
        Set<String> oldValue = getActionToHook();
        WikittyHookHelper.addAllActionToHook(getWikitty(), actionToHook);
        getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, oldValue, getActionToHook());
}

    /**
     * addActionToHook :
     * @param element 
     */

    @Override
    public void addActionToHook(String element) {
        WikittyHookHelper.addActionToHook(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, null, getActionToHook());
}

    /**
     * removeActionToHook :
     * @param element 
     */

    @Override
    public void removeActionToHook(String element) {
        WikittyHookHelper.removeActionToHook(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, null, getActionToHook());
}

    /**
     * clearActionToHook :
     */

    @Override
    public void clearActionToHook() {
        WikittyHookHelper.clearActionToHook(getWikitty());
        getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, null, getActionToHook());
}

    /**
     * getScript :
     * @return String 
     */

    @Override
    public String getScript() {
        String value = WikittyHookHelper.getScript(getWikitty());
        return value;
}

    /**
     * setScript :
     * @param script 
     */

    @Override
    public void setScript(String script) {
        String oldValue = getScript();
        WikittyHookHelper.setScript(getWikitty(), script);
        getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_SCRIPT, oldValue, getScript());
}

    /**
     * getMimetype :
     * @return String 
     */

    @Override
    public String getMimetype() {
        String value = WikittyHookHelper.getMimetype(getWikitty());
        return value;
}

    /**
     * setMimetype :
     * @param mimetype 
     */

    @Override
    public void setMimetype(String mimetype) {
        String oldValue = getMimetype();
        WikittyHookHelper.setMimetype(getWikitty(), mimetype);
        getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE, oldValue, getMimetype());
}

    /**
     * WikittyHookAbstract :
     */

    public WikittyHookAbstract() {
        super();
}

    /**
     * WikittyHookAbstract :
     * @param wikitty 
     */

    public WikittyHookAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyHookAbstract :
     * @param businessEntityImpl 
     */

    public WikittyHookAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyHook =
                new WikittyExtension(EXT_WIKITTYHOOK,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=\"true\"", 
                                             "String actionToHook[0-*] unique=\"true\"", 
                                             "String script unique=\"true\"", 
                                             "String mimetype unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyHook);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyHookAbstract
