/* *##%
 * Copyright (c) 2009 Sharengo, Guillaume Dufrene, Benjamin POUSSIN.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.nuiton.wikitty;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;

/**
 *
 * @author poussin
 * @version $Revision: 259 $
 *
 * Each business object will inherit of this class.
 *
 * Last update: $Date: 2010-08-13 14:52:59 +0200 (ven., 13 août 2010) $
 * by : $Author: sletellier $
 */
public class BusinessEntityWikitty implements BusinessEntity {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4399752739887114180L;

    /**
     * Property change support.
     * 
     * Warning, this transient field is null after deserialization.
     */
    protected transient PropertyChangeSupport propertyChangeSupport;

    protected Wikitty wikitty;

    public BusinessEntityWikitty(Wikitty wi) {
        setWikitty(wi);
    }

    public BusinessEntityWikitty() {
        this(new WikittyImpl());
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (propertyChangeSupport == null) {
            propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return propertyChangeSupport;
    }

    public String getWikittyId() {
        String result = getWikitty().getId();
        return result;
    }

    public String getWikittyVersion() {
        String result = getWikitty().getVersion();
        return result;
    }

    public void setWikittyVersion(String version) {
        getWikitty().setVersion(version);
    }

    public void setWikitty(Wikitty wikitty) {
        if(wikitty != null) {
            for (WikittyExtension ext : getStaticExtensions()) {
                wikitty.addExtension(ext);
            }
        }
        this.wikitty = wikitty;
    }

    public Wikitty getWikitty() {
        return wikitty;
    }
    
    public Collection<String> getExtensionNames() {
        Collection<String> result = getWikitty().getExtensionNames();
        return result;
    }

    public Collection<String> getExtensionFields(String ext) {
        Collection<String> result = getWikitty().getExtension(ext).getFieldNames();
        return result;
    }

    public FieldType getFieldType(String ext, String fieldName) {
        FieldType result = getWikitty().getExtension(ext).getFieldType(fieldName);
        return result;
    }

    public Object getField(String ext, String fieldName) {
        Object result = getWikitty().getFieldAsObject(ext, fieldName);
        return result;
    }

    public void setField(String ext, String fieldName, Object value) {
        getWikitty().setField(ext, fieldName, value);
    }

    public Collection<WikittyExtension> getStaticExtensions() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!BusinessEntityWikitty.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        BusinessEntityWikitty wikitty = (BusinessEntityWikitty) obj;
        return getWikittyId().equals(wikitty.getWikittyId());
    }

    @Override
    public int hashCode() {
        return getWikittyId().hashCode();
    }

    /*
    * @see org.nuiton.wikitty.BusinessEntity#addPropertyChangeListener(java.beans.PropertyChangeListener)
    */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    /*
     * @see org.nuiton.wikitty.BusinessEntity#removePropertyChangeListener(java.beans.PropertyChangeListener)
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    /*
     * @see org.nuiton.wikitty.BusinessEntity#addPropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
     */
    @Override
    public void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener) {
        getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    /*
     * @see org.nuiton.wikitty.BusinessEntity#removePropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
     */
    @Override
    public void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener) {
        getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }
}
