/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import java.util.List;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContext;
import org.nuiton.topia.persistence.internal.HibernateProvider;
import org.nuiton.topia.persistence.internal.TopiaHibernateSessionRegistry;
import org.nuiton.topia.persistence.support.TopiaListenableSupport;
import org.nuiton.topia.templates.TopiaGeneratorUtil;
import org.nuiton.topia.templates.TopiaTagValues;

public class PersistenceContextTransformer
extends ObjectModelTransformerToJava {
    public void transformFromModel(ObjectModel input) {
        boolean generateConcrete;
        String packageName = TopiaGeneratorUtil.getPersistenceContextPackage(this, (ObjectModel)this.model);
        String daoSupplierName = TopiaGeneratorUtil.getDaoSupplierName((ObjectModel)this.model);
        String persistenceContextAbstractName = TopiaGeneratorUtil.getPersistenceContextAbstractName((ObjectModel)this.model);
        String persistenceContextConcreteName = TopiaGeneratorUtil.getPersistenceContextConcreteName((ObjectModel)this.model);
        boolean generateDaoSupplier = !this.isInClassPath(packageName, daoSupplierName);
        boolean generateAbstract = !this.isInClassPath(packageName, persistenceContextAbstractName);
        boolean bl = generateConcrete = !this.isInClassPath(packageName, persistenceContextConcreteName);
        if (generateDaoSupplier) {
            this.generateDaoSupplier(packageName, daoSupplierName);
        }
        if (generateAbstract) {
            this.generateAbstract(packageName, persistenceContextAbstractName, daoSupplierName);
        }
        if (generateConcrete) {
            this.generateImpl(packageName, persistenceContextAbstractName, persistenceContextConcreteName);
        }
    }

    protected void generateDaoSupplier(String packageName, String className) {
        ObjectModelInterface output = this.createInterface(className, packageName);
        String contractName = TopiaGeneratorUtil.getDaoSupplierInterfaceName((ObjectModel)this.model);
        boolean addPersistenceContextContract = this.isInClassPath(packageName, contractName);
        if (addPersistenceContextContract) {
            this.addInterface((ObjectModelClassifier)output, packageName + "." + contractName);
        }
        this.addInterface((ObjectModelClassifier)output, TopiaDaoSupplier.class);
        List<ObjectModelClass> entityClasses = TopiaGeneratorUtil.getEntityClasses((ObjectModel)this.model, true);
        for (ObjectModelClass clazz : entityClasses) {
            String daoContractName = TopiaGeneratorUtil.getContractDaoName(clazz);
            String daoClazzName = TopiaGeneratorUtil.getConcreteDaoName(clazz);
            this.addOperation((ObjectModelClassifier)output, "get" + daoContractName, clazz.getPackageName() + '.' + daoClazzName, new ObjectModelModifier[0]);
        }
    }

    protected void generateAbstract(String packageName, String className, String daoSupplierName) {
        ObjectModelClass output = this.createAbstractClass(className, packageName);
        String superClass = TopiaTagValues.getPersistenceContextSuperClassTagValue((ObjectModel)this.model);
        if (superClass == null) {
            superClass = AbstractTopiaPersistenceContext.class.getName();
        }
        this.setSuperClass(output, superClass);
        String contractName = TopiaGeneratorUtil.getPersistenceContextInterfaceName((ObjectModel)this.model);
        boolean addPersistenceContextContract = this.isInClassPath(packageName, contractName);
        if (addPersistenceContextContract) {
            this.addInterface((ObjectModelClassifier)output, packageName + "." + contractName);
        }
        this.addInterface((ObjectModelClassifier)output, packageName + "." + daoSupplierName);
        this.addContructor(output, false);
        List<ObjectModelClass> entityClasses = TopiaGeneratorUtil.getEntityClasses((ObjectModel)this.model, true);
        for (ObjectModelClass clazz : entityClasses) {
            String clazzName = clazz.getName();
            String daoContractName = TopiaGeneratorUtil.getContractDaoName(clazz);
            String daoClazzName = TopiaGeneratorUtil.getConcreteDaoName(clazz);
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "get" + daoContractName, clazz.getPackageName() + '.' + daoClazzName, new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
            this.addImport((ObjectModelClassifier)output, clazz);
            this.setOperationBody(op, "\n        " + daoClazzName + " result = getDao(" + clazzName + ".class, " + daoClazzName + ".class);\n" + "        return result;\n" + "    ");
        }
    }

    protected ObjectModelClass generateImpl(String packageName, String entityAbstractName, String entityConcreteName) {
        ObjectModelClass output = this.createClass(entityConcreteName, packageName);
        this.setSuperClass(output, entityAbstractName);
        this.addContructor(output, true);
        return output;
    }

    protected void addContructor(ObjectModelClass output, boolean isPublic) {
        ObjectModelJavaModifier visibility = isPublic ? ObjectModelJavaModifier.PUBLIC : ObjectModelJavaModifier.PROTECTED;
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)visibility);
        this.addParameter(constructor, HibernateProvider.class, "hibernateProvider");
        this.addParameter(constructor, TopiaListenableSupport.class, "listenableSupport");
        this.addParameter(constructor, TopiaIdFactory.class, "topiaIdFactory");
        this.addParameter(constructor, TopiaHibernateSessionRegistry.class, "sessionRegistry");
        this.setOperationBody(constructor, "\n        super(hibernateProvider, listenableSupport, topiaIdFactory, sessionRegistry);\n    ");
    }
}

