/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.event.TopiaEntityEvent;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.security.TopiaSecurityServiceImpl;

public class EntityVetoable
implements TopiaEntityVetoable {
    private static Log log = LogFactory.getLog(EntityVetoable.class);
    private TopiaSecurityServiceImpl securityManager;

    public EntityVetoable(TopiaSecurityServiceImpl securityManager) {
        this.securityManager = securityManager;
    }

    public void create(TopiaEntityEvent event) {
        Class clazz;
        TopiaEntity entity = event.getEntity();
        String topiaId = entity.getTopiaId();
        try {
            clazz = TopiaId.getClassName((String)topiaId);
        }
        catch (TopiaNotFoundException e) {
            throw new SecurityException("Access denied to entity creation", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] create entity : " + clazz.getName()));
        }
        this.securityManager.checkPermission(clazz, 2);
    }

    public void delete(TopiaEntityEvent event) {
        String topiaId = event.getEntity().getTopiaId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] delete entity : " + topiaId));
        }
        this.securityManager.checkPermission(topiaId, 8);
    }

    public void load(TopiaEntityEvent event) {
        boolean contain;
        boolean authorized = true;
        TopiaEntity entity = event.getEntity();
        String topiaId = entity.getTopiaId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] load entity : " + topiaId));
        }
        if (!(contain = this.securityManager.containEntitiesLoadingCache(topiaId))) {
            try {
                this.securityManager.checkPermission(topiaId, 1);
            }
            catch (SecurityException te) {
                authorized = false;
            }
            this.securityManager.putEntitiesLoadingCache(topiaId, authorized);
        }
    }

    public void update(TopiaEntityEvent event) {
    }
}

