package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Fri Jul 04 16:02:50 CEST 2014")
public abstract class TopiaAssociationAuthorizationAbstract extends TopiaAuthorizationImpl implements TopiaAssociationAuthorization {

    /**
     * Nom de l'attribut en BD : idBeginAssociation
     */
    protected String idBeginAssociation;

    /**
     * Nom de l'attribut en BD : nameAssociation
     */
    protected String nameAssociation;

    /**
     * Nom de l'attribut en BD : actions
     */
    protected int actions;

    /**
     * Nom de l'attribut en BD : principals
     */
    protected Set principals;

    private static final long serialVersionUID = 7147828560201397857L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(EntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, ID_BEGIN_ASSOCIATION, String.class, idBeginAssociation);
        visitor.visit(this, NAME_ASSOCIATION, String.class, nameAssociation);
        visitor.visit(this, ACTIONS, int.class, actions);
        visitor.visit(this, PRINCIPALS, Set.class, principals);
    }

    @Override
    public void setIdBeginAssociation(String idBeginAssociation) {
        String oldValue = this.idBeginAssociation;
        fireOnPreWrite(ID_BEGIN_ASSOCIATION, oldValue, idBeginAssociation);
        this.idBeginAssociation = idBeginAssociation;
        fireOnPostWrite(ID_BEGIN_ASSOCIATION, oldValue, idBeginAssociation);
    }

    @Override
    public String getIdBeginAssociation() {
        fireOnPreRead(ID_BEGIN_ASSOCIATION, idBeginAssociation);

        String result = this.idBeginAssociation;

        fireOnPostRead(ID_BEGIN_ASSOCIATION, idBeginAssociation);

        return result;
    }

    @Override
    public void setNameAssociation(String nameAssociation) {
        String oldValue = this.nameAssociation;
        fireOnPreWrite(NAME_ASSOCIATION, oldValue, nameAssociation);
        this.nameAssociation = nameAssociation;
        fireOnPostWrite(NAME_ASSOCIATION, oldValue, nameAssociation);
    }

    @Override
    public String getNameAssociation() {
        fireOnPreRead(NAME_ASSOCIATION, nameAssociation);

        String result = this.nameAssociation;

        fireOnPostRead(NAME_ASSOCIATION, nameAssociation);

        return result;
    }

    @Override
    public void setActions(int actions) {
        int oldValue = this.actions;
        fireOnPreWrite(ACTIONS, oldValue, actions);
        this.actions = actions;
        fireOnPostWrite(ACTIONS, oldValue, actions);
    }

    @Override
    public int getActions() {
        fireOnPreRead(ACTIONS, actions);

        int result = this.actions;

        fireOnPostRead(ACTIONS, actions);

        return result;
    }

    @Override
    public void setPrincipals(Set principals) {
        Set oldValue = this.principals;
        fireOnPreWrite(PRINCIPALS, oldValue, principals);
        this.principals = principals;
        fireOnPostWrite(PRINCIPALS, oldValue, principals);
    }

    @Override
    public Set getPrincipals() {
        fireOnPreRead(PRINCIPALS, principals);

        Set result = this.principals;

        fireOnPostRead(PRINCIPALS, principals);

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(ID_BEGIN_ASSOCIATION, this.idBeginAssociation).
            append(NAME_ASSOCIATION, this.nameAssociation).
            append(ACTIONS, this.actions).
            append(PRINCIPALS, this.principals).
         toString();
        return result;
    }

} //TopiaAssociationAuthorizationAbstract
