package org.nuiton.topia.taas.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class TaasPrincipalDAOAbstract<E extends TaasPrincipal> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TaasPrincipal.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<org.nuiton.topia.taas.entities.TaasUser> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from taasUser main, principals_users secondary " +
                    "where main.topiaid=secondary.users" +
                    " and secondary.principals='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(org.nuiton.topia.taas.entities.TaasUser.class)).list();
            for (org.nuiton.topia.taas.entities.TaasUser item : list) {
                item.removePrincipals(entity);
            }
        }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findContainsAuthorizations :
     * Retourne le premier élément trouvé dont l'attribut authorizations contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsAuthorizations(TaasAuthorization... v) throws TopiaException {
        E result = findContainsProperties("authorizations", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsAuthorizations :
     * Retourne les éléments trouvé dont l'attribut authorizations contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsAuthorizations(TaasAuthorization... v) throws TopiaException {
        List<E> results = findAllContainsProperties("authorizations", Arrays.asList(v));
        return results;
    }


} //TaasPrincipalDAOAbstract<E extends TaasPrincipal>
