/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;

public class TopiaServiceSupportImpl
implements TopiaServiceSupport {
    private static final Log log = LogFactory.getLog(TopiaServiceSupportImpl.class);
    protected ImmutableMap<String, TopiaService> services;
    protected AbstractTopiaApplicationContext topiaApplicationContext;

    public TopiaServiceSupportImpl(AbstractTopiaApplicationContext topiaApplicationContext) {
        this.topiaApplicationContext = topiaApplicationContext;
        this.services = this.loadServices(topiaApplicationContext.getConfiguration());
    }

    public void init() {
        this.preInitServices((Map<String, TopiaService>)this.services);
        this.topiaApplicationContext.getHibernateProvider().getHibernateConfiguration();
        this.postInitServices((Map<String, TopiaService>)this.services);
    }

    protected void preInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            service.preInit(this.topiaApplicationContext);
        }
    }

    protected void postInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            service.postInit(this.topiaApplicationContext);
        }
    }

    protected ImmutableMap<String, TopiaService> loadServices(ImmutableMap<String, String> configuration) {
        HashMap<String, TopiaService> services = new HashMap<String, TopiaService>();
        HashMap servicesConfigurations = new HashMap();
        for (Map.Entry entry : configuration.entrySet()) {
            String prefixedConfigurationKey = (String)entry.getKey();
            String configurationValue = (String)entry.getValue();
            if (!prefixedConfigurationKey.startsWith("topia.service.")) continue;
            String configurationKey = StringUtils.removeStart((String)prefixedConfigurationKey, (String)"topia.service.");
            String[] split = StringUtils.split((String)configurationKey, (char)'.');
            Preconditions.checkState((split.length > 0 ? 1 : 0) != 0, (Object)("'" + prefixedConfigurationKey + "' is not a valid configuration key"));
            String serviceName = split[0];
            if (split.length == 1) {
                try {
                    Class<?> forName = Class.forName(configurationValue);
                    Object newInstance = forName.getConstructor(new Class[0]).newInstance(new Object[0]);
                    TopiaService service = (TopiaService)newInstance;
                    services.put(serviceName, service);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("instantiated service " + serviceName + ": " + service));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaException("unable to find topia service class " + configurationValue, e);
                }
                catch (InstantiationException e) {
                    throw new TopiaException("unable to instantiate class " + configurationValue, e);
                }
                catch (IllegalAccessException e) {
                    throw new TopiaException("unable to instantiate class " + configurationValue, e);
                }
                catch (InvocationTargetException e) {
                    throw new TopiaException("unable to instantiate class " + configurationValue, e);
                }
                catch (NoSuchMethodException e) {
                    throw new TopiaException("unable to instantiate class " + configurationValue, e);
                }
            }
            LinkedHashMap<String, String> serviceConfiguration = (LinkedHashMap<String, String>)servicesConfigurations.get(serviceName);
            if (serviceConfiguration == null) {
                serviceConfiguration = new LinkedHashMap<String, String>();
                servicesConfigurations.put(serviceName, serviceConfiguration);
            }
            String serviceConfigurationKey = StringUtils.removeStart((String)configurationKey, (String)(serviceName + "."));
            serviceConfiguration.put(serviceConfigurationKey, configurationValue);
        }
        for (Map.Entry entry : services.entrySet()) {
            String serviceName = (String)entry.getKey();
            TopiaService service = (TopiaService)entry.getValue();
            Map<String, String> serviceConfiguration = (Map<String, String>)servicesConfigurations.get(serviceName);
            if (serviceConfiguration == null) {
                serviceConfiguration = Collections.emptyMap();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("for service " + serviceName + ", will set configuration " + serviceConfiguration));
            }
            service.setConfiguration(serviceConfiguration);
        }
        return ImmutableMap.copyOf(services);
    }

    @Override
    public Map<String, TopiaService> getServices() {
        return this.services;
    }

    @Override
    public <T extends TopiaService> Map<String, T> getServices(Class<T> interfaceService) {
        LinkedHashMap<String, TopiaService> result = new LinkedHashMap<String, TopiaService>();
        for (Map.Entry entry : this.services.entrySet()) {
            String serviceName = (String)entry.getKey();
            TopiaService service = (TopiaService)entry.getValue();
            if (!interfaceService.isAssignableFrom(service.getClass())) continue;
            result.put(serviceName, service);
        }
        return result;
    }
}

