package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaService.java 2983 2014-01-18 18:21:51Z athimel $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-2/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaService.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;

/**
 * Used to implement a service for Topia. You have to provide a static property called SERVICE_NAME that identify the
 * service:
 * <p/>
 * <li>public static final String SERVICE_NAME = "monservice";
 * <p/>
 * The value of this attribute need to be returned when using {@link #getServiceName()} method.
 * <p/>
 * Created: 8 oct. 06 17:15:52
 *
 * @author poussin <poussin@codelutin.com>
 */
public interface TopiaService {

    /**
     * Return the name of the service, this name need to match with
     * configuration file, for example for index service, we need to have :
     * "topia.service.index" and this method will returned "index".
     *
     * @return the service name
     */
    String getServiceName();

    /**
     * Retrieve entities of this service needed for persistence.
     *
     * @return List of entities full qualified name separated by a comma
     */
    Class<?>[] getPersistenceClasses();

    /**
     * Initiliaze the service before create the {@code context}.
     *
     * @param context
     * @return true if service need to be activated or not
     */
    boolean preInit(AbstractTopiaApplicationContext context);

    /**
     * Initiliaze the service after create the {@code context}.
     *
     * @param context
     * @return true if service need to be activated or not
     */
    boolean postInit(TopiaApplicationContext context);

}
