/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.framework.TopiaContextImpl;

public class TopiaContextFactoryTest {
    private static final Log log = LogFactory.getLog(TopiaContextFactoryTest.class);
    protected static File testBasedir;
    protected Properties properties;

    @BeforeClass
    public static void init() throws IOException {
        testBasedir = TopiaDatabase.getTestSpecificDirectory(TopiaContextFactoryTest.class, "dummy");
    }

    @Before
    public void setUp() throws Exception {
        this.properties = new Properties();
        this.properties.setProperty("prop1", "value1");
        this.properties.setProperty("prop2", "value2");
        TopiaContextFactory.contextCache.clear();
    }

    @Test
    public void testGetContextOpened() throws Exception {
        log.debug((Object)"## testGetContextOpened");
        String databaseName = "h2data-testGetContextByPropertie";
        File dbDirectory = new File(testBasedir, databaseName);
        String url = "jdbc:h2:file:" + dbDirectory;
        this.properties.setProperty("hibernate.connection.url", url);
        TopiaContextImpl test = new TopiaContextImpl(this.properties);
        TopiaContextFactory.contextCache.put(this.properties, test);
        List result = TopiaContextFactory.getContextOpened();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)url, result.get(0));
    }

    @Test
    public void testRemoveContext() throws Exception {
        log.debug((Object)"## testRemoveContext");
        TopiaContextImpl test = new TopiaContextImpl(this.properties);
        TopiaContextFactory.contextCache.put(this.properties, test);
        TopiaContextFactory.removeContext((TopiaContext)test);
        Assert.assertEquals((long)0L, (long)TopiaContextFactory.contextCache.size());
    }

    public void testGetContext() throws Exception {
    }

    @Test
    public void testGetContextByProperties() throws Exception {
        log.debug((Object)"## testGetContextByProperties");
        Properties propertiesParent = new Properties(this.properties);
        propertiesParent.setProperty("prop3", "value3");
        Properties propertiesAll = new Properties();
        propertiesAll.setProperty("prop1", "value1");
        propertiesAll.setProperty("prop2", "value2");
        propertiesAll.setProperty("prop3", "value3");
        log.info((Object)"test 0 : add null properties");
        try {
            TopiaContextFactory.getContext(null);
        }
        catch (Exception eee) {
            Assert.assertEquals(NullPointerException.class, eee.getClass());
        }
        log.info((Object)"test 1 : add new properties, will instantiate a new TopiaContext");
        TopiaContext test1 = TopiaContextFactory.getContext((Properties)propertiesParent);
        Assert.assertNotNull((Object)test1);
        Assert.assertEquals((long)1L, (long)TopiaContextFactory.contextCache.size());
        log.info((Object)"test 2 : with same properties, will retrieve existing TopiaContext");
        TopiaContext test2 = TopiaContextFactory.getContext((Properties)propertiesParent);
        Assert.assertEquals((Object)test1, (Object)test2);
        Assert.assertEquals((long)1L, (long)TopiaContextFactory.contextCache.size());
        log.info((Object)"test 3 : use other properties, will instantiate a differentTopiaContext");
        TopiaContext test3 = TopiaContextFactory.getContext((Properties)this.properties);
        log.debug((Object)("cache size : " + TopiaContextFactory.contextCache.size()));
        log.debug((Object)("result : " + test1));
        log.debug((Object)("result3 : " + test3));
        Assert.assertNotSame((Object)test1, (Object)test3);
        Assert.assertEquals((long)2L, (long)TopiaContextFactory.contextCache.size());
        log.info((Object)"test 4 : use other properties but equivalent to existing TopiaContext");
        TopiaContext test4 = TopiaContextFactory.getContext((Properties)propertiesAll);
        Assert.assertEquals((Object)test1, (Object)test4);
        Assert.assertEquals((long)2L, (long)TopiaContextFactory.contextCache.size());
        log.info((Object)"test5a : reinstantiate new TopiaContext after one is closed.");
        String databaseName = "h2data-testGetContextByPropertie";
        File f = new File(testBasedir, databaseName);
        this.properties.setProperty("hibernate.connection.username", "sa");
        this.properties.setProperty("hibernate.connection.password", "");
        this.properties.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
        this.properties.setProperty("hibernate.connection.url", "jdbc:h2:file:" + f.getAbsolutePath());
        TopiaContext test5 = TopiaContextFactory.getContext((Properties)this.properties);
        Assert.assertNotSame((Object)test1, (Object)test5);
        Assert.assertEquals((long)3L, (long)TopiaContextFactory.contextCache.size());
        log.info((Object)"test5b : beginTransaction to properly close the context");
        test5.beginTransaction();
        test5.closeContext();
        TopiaContext result = TopiaContextFactory.getContext((Properties)this.properties);
        Assert.assertNotSame((Object)test5, (Object)result);
        Assert.assertEquals((long)3L, (long)TopiaContextFactory.contextCache.size());
    }
}

