/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.test.ano1882;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.NaturalIdTest;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class DAOAbstractTransformerTest {

    private static final Log log = LogFactory.getLog(NaturalIdTest.class);

    protected static File testBasedir;

    @BeforeClass
    public static void setUpClass() throws Exception {

        testBasedir = TestHelper.getTestBasedir(NaturalIdTest.class);
    }

    protected TopiaContext initTopiaContext(String testName) throws IOException, TopiaNotFoundException {
        TopiaContext root = TestHelper.initTopiaContext(testBasedir,
                                                        "/TopiaContextImpl.properties",
                                                        testName);
        return root;
    }

    @Test
    public void testAno1882() throws Exception {
        TopiaContext rootContext = initTopiaContext("testAno1882");
        TopiaContext transaction = rootContext.beginTransaction();
        try {
            FrenchCompanyDAO dao = TopiaTestDAOHelper.getFrenchCompanyDAO(transaction);
            SIRETDAO siretDAO = TopiaTestDAOHelper.getSIRETDAO(transaction);
            SIRET siret = siretDAO.create();
            FrenchCompany entity =
                    dao.create(
                            FrenchCompany.PROPERTY_S_IREN, null,
                            FrenchCompany.PROPERTY_SIREN2, null,
                            FrenchCompany.PROPERTY_S_IRET, Arrays.asList(siret),
                            FrenchCompany.PROPERTY_SIRET2, null);
            transaction.commitTransaction();
            dao.delete(entity);
            transaction.commitTransaction();
        } finally {
            rootContext.closeContext();
        }
    }
}
