/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class EntityHibernateMappingGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(EntityHibernateMappingGenerator.class);
    private static final String HIBERNATE_ATTRIBUTE_DEFAULT = "default";
    private static final String HIBERNATE_ATTRIBUTE_SQL_TYPE = "sql-type";
    private static final String HIBERNATE_ATTRIBUTE_NAME = "name";
    private Map<String, String[]> columnNamesMap = new HashMap<String, String[]>();
    public static final String HIBERNATE_ATTRIBUTE_LAZY = "lazy";
    public static final String HIBERNATE_ATTRIBUTE_FETCH = "fetch";
    public static final String HIBERNATE_ATTRIBUTE_NOT_NULL = "not-null";
    public static final String HIBERNATE_ATTRIBUTE_SCHEMA = "schema";
    public static final String HIBERNATE_ATTRIBUTE_INDEX = "index";
    public static final String HIBERNATE_ATTRIBUTE_UNIQUE = "unique";
    public static final String HIBERNATE_ATTRIBUTE_LENGTH = "length";
    public static final String HIBERNATE_ATTRIBUTE_ORDER_BY = "order-by";

    public String getFilenameForClass(ObjectModelClass clazz) {
        String DOName = TopiaGeneratorUtil.getDOType((ObjectModelElement)clazz, (ObjectModel)this.model);
        return DOName.replace('.', File.separatorChar) + ".hbm.xml";
    }

    public void generateFromClass(Writer output, ObjectModelClass input) throws IOException {
        String proxyTagValue;
        String persistenceType = TopiaGeneratorUtil.getPersistenceType((ObjectModelClassifier)input);
        if (!TopiaGeneratorUtil.isEntity((ObjectModelClassifier)input) && "hibernate".equals(persistenceType)) {
            return;
        }
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\" \"classpath://org/hibernate/hibernate-mapping-3.0.dtd\">\n");
        output.write("<hibernate-mapping default-access=\"field\" auto-import=\"true\" package=\"" + input.getPackageName() + "\">\n");
        output.write("");
        boolean haveSuper = input.getSuperclasses().size() > 0;
        ArrayList<ObjectModelAttribute> naturalAttributes = new ArrayList<ObjectModelAttribute>();
        ArrayList<ObjectModelAttribute> noneNaturalAttributes = new ArrayList<ObjectModelAttribute>();
        String clazzDOType = TopiaGeneratorUtil.getDOType((ObjectModelElement)input, (ObjectModel)this.model);
        String tableName = TopiaGeneratorUtil.getDbName((ObjectModelElement)input);
        String isAbstract = BooleanUtils.toStringTrueFalse((boolean)input.isAbstract());
        String clazzFQN = input.getQualifiedName();
        String optionalAttributes = "";
        String schema = TopiaGeneratorUtil.getDbSchemaNameTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
        if (schema != null) {
            optionalAttributes = optionalAttributes + "schema=\"" + schema + "\" ";
        }
        if (StringUtils.isEmpty((CharSequence)(proxyTagValue = TopiaGeneratorUtil.getProxyInterfaceTagValue((ObjectModelClassifier)input, (ObjectModel)this.model))) || !proxyTagValue.equals("none")) {
            optionalAttributes = optionalAttributes + "proxy=\"" + clazzFQN + "\" ";
        }
        if (haveSuper) {
            ObjectModelClass superClass = (ObjectModelClass)input.getSuperclasses().iterator().next();
            String superClassname = superClass.getQualifiedName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("superClass for " + input.getQualifiedName() + " is " + superClassname));
            }
            String superClassDOType = TopiaGeneratorUtil.getDOType(superClassname, (ObjectModel)this.model);
            output.write("    <union-subclass name=\"" + clazzDOType + "\" extends=\"" + superClassDOType + "\" table=\"" + tableName + "\" node=\"" + clazzDOType + "\" abstract=\"" + isAbstract + "\" " + optionalAttributes + ">\n");
            output.write("        <!--key column=\"topiaId\"/-->\n");
            output.write("");
            noneNaturalAttributes.addAll(input.getAttributes());
        } else {
            output.write("    <class name=\"" + clazzDOType + "\" table=\"" + tableName + "\" node=\"" + clazzDOType + "\" abstract=\"" + isAbstract + "\" " + optionalAttributes + ">\n");
            output.write("        <id name=\"topiaId\" type=\"string\" length=\"255\" node=\"@topiaId\"/>\n");
            output.write("");
            for (ObjectModelAttribute attr : input.getAttributes()) {
                if (TopiaGeneratorUtil.isNaturalId(attr)) {
                    naturalAttributes.add(attr);
                    continue;
                }
                noneNaturalAttributes.add(attr);
            }
            if (!naturalAttributes.isEmpty()) {
                String mutableStr;
                boolean mutable = TopiaGeneratorUtil.isNaturalIdMutable(input);
                String string = mutableStr = mutable ? " mutable=\"true\"" : "";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("natural-id detected for class " + input.getName() + " (" + mutableStr + ") attributes : " + naturalAttributes));
                }
                output.write("        <natural-id" + mutableStr + ">\n");
                output.write("");
                this.generateAttributes(output, input, naturalAttributes, "    ");
                output.write("        </natural-id>\n");
                output.write("");
            }
            output.write("        <version name=\"topiaVersion\" type=\"long\" node=\"@topiaVersion\"/>\n");
            output.write("        <property name=\"topiaCreateDate\" type=\"timestamp\" node=\"@topiaCreateDate\"/>\n");
            output.write("");
        }
        this.generateAttributes(output, input, noneNaturalAttributes, "");
        if (haveSuper) {
            output.write("    </union-subclass>\n");
            output.write("");
        } else {
            output.write("    </class>\n");
            output.write("");
        }
        output.write("</hibernate-mapping>\n");
        output.write("");
    }

    protected void generateAttributes(Writer output, ObjectModelClass clazz, List<ObjectModelAttribute> attributes, String prefix) throws IOException {
        for (ObjectModelAttribute attr : attributes) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                if (attr.getClassifier() != null && TopiaGeneratorUtil.isEntity(attr.getClassifier())) {
                    if (GeneratorUtil.isNMultiplicity((int)attr.getReverseMaxMultiplicity()) && !attr.hasAssociationClass()) {
                        this.generateHibernateManyToOne(output, attr, prefix);
                        continue;
                    }
                    this.generateHibernateOneToOne(output, attr, prefix);
                    continue;
                }
                this.generateHibernateProperty(output, attr, prefix);
                continue;
            }
            if (attr.getClassifier() != null && TopiaGeneratorUtil.isEntity(attr.getClassifier())) {
                if (GeneratorUtil.isNMultiplicity((int)attr.getReverseMaxMultiplicity()) && !attr.hasAssociationClass()) {
                    this.generateHibernateManyToMany(output, attr, prefix);
                    continue;
                }
                this.generateHibernateOneToMany(output, attr, prefix);
                continue;
            }
            this.generateHibernateMany(output, attr, prefix);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String notNull = " " + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_NOT_NULL, TopiaGeneratorUtil.getNotNullTagValue(attr));
                String attrName = this.getName(attr, true);
                String attrType = this.getType(attr, true);
                String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, TopiaGeneratorUtil.getLazyTagValue(attr));
                String attrColumn = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr);
                output.write("" + prefix + "        <many-to-one name=\"" + attrName + "\" class=\"" + attrType + "\" " + lazy + "column=\"" + attrColumn + "\" node=\"" + attrName + "/@topiaId\" embed-xml=\"false\" " + notNull + "/>\n");
                output.write("");
            }
        }
    }

    protected String getName(ObjectModelAttribute attr) {
        return this.getName(attr, false);
    }

    protected String getName(ObjectModelAttribute attr, boolean isAssoc) {
        String result = GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName());
        if (attr.hasAssociationClass() && !isAssoc) {
            result = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
        }
        return result;
    }

    protected String getType(ObjectModelAttribute attr) {
        return this.getType(attr, false);
    }

    protected String getType(ObjectModelAttribute attr, boolean isAssoc) {
        String type = attr.getType();
        String attrType = TopiaGeneratorUtil.getTypeTagValue(attr);
        if (StringUtils.isNotEmpty((CharSequence)attrType)) {
            type = attrType;
        } else {
            String modelType = ((ObjectModel)this.model).getTagValue(type);
            if (StringUtils.isNotEmpty((CharSequence)modelType)) {
                int bracketIndex = modelType.indexOf(40);
                if (bracketIndex != -1) {
                    type = modelType.substring(0, bracketIndex);
                    int bracketEndIndex = modelType.indexOf(41, bracketIndex + 1);
                    String colmunList = bracketEndIndex != -1 ? modelType.substring(bracketIndex + 1, bracketEndIndex) : modelType.substring(bracketIndex);
                    this.columnNamesMap.put(type, colmunList.split(","));
                } else {
                    type = modelType;
                }
            }
        }
        if (attr.hasAssociationClass() && !isAssoc) {
            type = attr.getAssociationClass().getQualifiedName();
        }
        return TopiaGeneratorUtil.getDOType(type, (ObjectModel)this.model);
    }

    protected void generateHibernateProperty(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean attrIsEnumeration;
        String attrType = this.getType(attr);
        String accessField = "field";
        String tagValue = TopiaGeneratorUtil.getAccessTagValue(attr);
        if (StringUtils.isNotEmpty((CharSequence)tagValue)) {
            accessField = tagValue;
        }
        String attrName = attr.getName();
        String declaringElementDBName = TopiaGeneratorUtil.getDbName(attr.getDeclaringElement());
        String tableName = declaringElementDBName + "_" + attrName;
        boolean bl = attrIsEnumeration = attr.getClassifier() != null && attr.getClassifier().isEnum();
        if (attrType.trim().endsWith("[]")) {
            attrType = attrType.trim().substring(0, attrType.trim().length() - 2);
            String optionalAttributes = "";
            String schema = TopiaGeneratorUtil.getDbSchemaNameTagValue(attr, (ObjectModel)this.model);
            if (schema != null) {
                optionalAttributes = optionalAttributes + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_SCHEMA, schema);
            }
            if (JavaGeneratorUtil.hasIndexedStereotype((ObjectModelAttribute)attr)) {
                String indexName = tableName + "_idx";
                optionalAttributes = optionalAttributes + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_INDEX, indexName);
            }
            output.write("" + prefix + "        <primitive-array name=\"" + attrName + "\" table=\"" + tableName + "\" access=\"" + accessField + "\" " + optionalAttributes + ">\n");
            output.write("" + prefix + "          <key column=\"" + declaringElementDBName + "\"/>\n");
            output.write("" + prefix + "          <list-index column=\"" + attrName + "_idx\"/>\n");
            output.write("" + prefix + "          <element type=\"" + attrType + "\"/>\n");
            output.write("" + prefix + "        </primitive-array>\n");
            output.write("");
        } else {
            boolean noSpecifiedColumn;
            String lengthTagValue;
            String sqlType;
            String optionalAttributes = "";
            if (JavaGeneratorUtil.hasIndexedStereotype((ObjectModelAttribute)attr)) {
                String indexName = tableName + "_idx";
                optionalAttributes = optionalAttributes + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_INDEX, indexName);
            }
            if (TopiaGeneratorUtil.hasUniqueStereotype(attr)) {
                optionalAttributes = optionalAttributes + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_UNIQUE, "true");
            }
            optionalAttributes = optionalAttributes + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_NOT_NULL, TopiaGeneratorUtil.getNotNullTagValue(attr));
            output.write("" + prefix + "        <property name=\"" + attrName + "\" access=\"" + accessField + "\"");
            if (!attrIsEnumeration) {
                output.write(" type=\"" + attrType + "\"");
            }
            optionalAttributes = optionalAttributes.trim();
            String[] columnNames = this.columnNamesMap.get(attrType);
            TreeMap<String, String> columnAttributes = new TreeMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)attr.getDefaultValue())) {
                String defaultValue = attr.getDefaultValue().trim();
                columnAttributes.put(HIBERNATE_ATTRIBUTE_DEFAULT, defaultValue);
            }
            if (!StringUtils.isEmpty((CharSequence)(sqlType = TopiaGeneratorUtil.getSqlTypeTagValue(attr)))) {
                columnAttributes.put(HIBERNATE_ATTRIBUTE_SQL_TYPE, sqlType);
            }
            if (!StringUtils.isEmpty((CharSequence)(lengthTagValue = TopiaGeneratorUtil.getLengthTagValue(attr)))) {
                optionalAttributes = optionalAttributes + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LENGTH, lengthTagValue);
            }
            if (StringUtils.isNotEmpty((CharSequence)(optionalAttributes = optionalAttributes.trim()))) {
                optionalAttributes = " " + optionalAttributes;
            }
            boolean bl2 = noSpecifiedColumn = columnNames == null || columnNames.length == 0;
            if (noSpecifiedColumn) {
                String attrColumn = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr);
                if (columnAttributes.isEmpty()) {
                    output.write(" column=\"" + attrColumn + "\" node=\"" + attrName + "\"" + optionalAttributes + "");
                    if (attrIsEnumeration) {
                        output.write(">\n");
                        output.write("" + prefix + "            <type name=\"org.hibernate.type.EnumType\">\n");
                        output.write("" + prefix + "                <param name=\"" + "enumClass" + "\">" + attrType + "</param>");
                        boolean useEnumerationName = TopiaGeneratorUtil.hasUseEnumerationNameTagValue(attr, (ObjectModel)this.model);
                        if (useEnumerationName) {
                            String enumSQLType = String.valueOf(12);
                            output.write("\n");
                            output.write("" + prefix + "                <!-- using name instead of ordinal to store enumeration value -->\n");
                            output.write("" + prefix + "                <param name=\"" + "type" + "\">" + enumSQLType + "</param>");
                        }
                        output.write("\n");
                        output.write("" + prefix + "            </type>\n");
                        output.write("" + prefix + "        </property>\n");
                        output.write("");
                    } else {
                        output.write("/>\n");
                        output.write("");
                    }
                } else {
                    columnAttributes.put(HIBERNATE_ATTRIBUTE_NAME, attrColumn);
                    String columnAttributesAsString = "";
                    for (Map.Entry entry : columnAttributes.entrySet()) {
                        String name = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        columnAttributesAsString = columnAttributesAsString + this.generateFromTagValue(name, value, null);
                    }
                    columnAttributesAsString = " " + columnAttributesAsString.trim();
                    output.write("" + optionalAttributes + ">\n");
                    output.write("" + prefix + "            <column" + columnAttributesAsString + "/>\n");
                    output.write("" + prefix + "        </property>\n");
                    output.write("");
                }
            } else {
                output.write("" + optionalAttributes + ">\n");
                output.write("");
                for (String columnName : columnNames) {
                    columnName = attrName + "_" + columnName.trim();
                    output.write("" + prefix + "            <column name=\"" + columnName + "\"/>\n");
                    output.write("");
                }
                output.write("" + prefix + "        </property>\n");
                output.write("");
            }
        }
    }

    protected void generateHibernateOneToOne(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean unique = TopiaGeneratorUtil.isOneMultiplicity((ObjectModelAttribute)attr);
        this.generateHibernateManyToOne(output, attr, unique, prefix);
    }

    protected void generateHibernateOneToMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean needsIndex = JavaGeneratorUtil.hasIndexedStereotype((ObjectModelAttribute)attr);
        boolean isInverse = attr.getReverseAttribute().isNavigable();
        isInverse |= TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model);
        String attrName = this.getName(attr);
        String attrType = this.getType(attr);
        String reverseAttrDBName = TopiaGeneratorUtil.getReverseDbName(attr);
        String orderBy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_ORDER_BY, TopiaGeneratorUtil.getOrderByTagValue(attr));
        String cascade = "";
        if (attr.isComposite() || attr.hasAssociationClass()) {
            cascade = cascade + "cascade=\"all,delete-orphan\" ";
        }
        String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, TopiaGeneratorUtil.getLazyTagValue(attr), "true");
        String fetch = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_FETCH, TopiaGeneratorUtil.getFetchTagValue(attr));
        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String inverse = "";
        if (isInverse) {
            inverse = "inverse=\"true\" ";
        }
        if (needsIndex) {
            output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" " + inverse + "" + lazy + "" + cascade + "node=\"" + attrName + "\" embed-xml=\"false\">\n");
            output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"/>\n");
            output.write("" + prefix + "            <list-index column=\"" + reverseAttrDBName + "_idx\"/>\n");
            output.write("" + prefix + "            <one-to-many class=\"" + attrType + "\" node=\"topiaId\" embed-xml=\"false\"/>\n");
            output.write("" + prefix + "        </" + collType + ">\n");
            output.write("");
        } else {
            output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" " + inverse + "" + orderBy + "" + fetch + "" + lazy + "" + cascade + "node=\"" + attrName + "\" embed-xml=\"false\">\n");
            output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"/>\n");
            output.write("" + prefix + "            <one-to-many class=\"" + attrType + "\" node=\"topiaId\" embed-xml=\"false\"/>\n");
            output.write("" + prefix + "        </" + collType + ">\n");
            output.write("");
        }
    }

    private String generateFromTagValue(String attributeName, String tagValue) {
        return this.generateFromTagValue(attributeName, tagValue, null);
    }

    private String generateFromTagValue(String attributeName, String tagValue, String defaultValue) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)tagValue)) {
            result = result + attributeName + "=\"" + tagValue + "\" ";
        } else if (defaultValue != null) {
            result = result + attributeName + "=\"" + defaultValue + "\" ";
        }
        return result;
    }

    protected void generateHibernateMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean needsIndex = JavaGeneratorUtil.hasIndexedStereotype((ObjectModelAttribute)attr);
        String attrName = this.getName(attr);
        String attrType = this.getType(attr);
        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, TopiaGeneratorUtil.getLazyTagValue(attr));
        String attrColumn = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr);
        output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" " + lazy + "node=\"" + attrName + "\" embed-xml=\"true\">\n");
        output.write("" + prefix + "            <key column=\"OWNER\"/>\n");
        output.write("");
        if (needsIndex) {
            output.write("" + prefix + "        <list-index/>\n");
            output.write("");
        }
        output.write("" + prefix + "            <element type=\"" + attrType + "\" column=\"" + attrColumn + "\" node=\"id\"/>\n");
        output.write("" + prefix + "        </" + collType + ">\n");
        output.write("");
    }

    protected void generateHibernateManyToOne(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        this.generateHibernateManyToOne(output, attr, false, prefix);
    }

    protected void generateHibernateManyToOne(Writer output, ObjectModelAttribute attr, boolean isUnique, String prefix) throws IOException {
        String attrName = this.getName(attr);
        String attrType = this.getType(attr);
        String attrColumn = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr);
        output.write("" + prefix + "        <many-to-one name=\"" + attrName + "\" class=\"" + attrType + "\" column=\"" + attrColumn + "\" ");
        if (attr.isComposite() || attr.hasAssociationClass()) {
            output.write("cascade=\"delete\" ");
        }
        if (attr.getReverseAttribute() != null && TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr.getReverseAttribute(), (ObjectModel)this.model)) {
            output.write("access=\"field\" ");
        }
        String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, TopiaGeneratorUtil.getLazyTagValue(attr));
        output.write("" + lazy + "");
        String notNull = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_NOT_NULL, TopiaGeneratorUtil.getNotNullTagValue(attr));
        output.write("" + notNull + "");
        if (isUnique) {
            output.write("unique=\"true\" ");
        }
        output.write("node=\"" + attrName + "/@topiaId\" embed-xml=\"false\"");
        output.write("/>\n");
        output.write("");
    }

    protected void generateHibernateManyToMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean isInverse = attr.isNavigable() && attr.getReverseAttribute().isNavigable();
        String inverseValue = TopiaGeneratorUtil.getInverseTagValue(attr);
        isInverse = StringUtils.isNotEmpty((CharSequence)inverseValue) ? (isInverse &= Boolean.parseBoolean(inverseValue)) : (isInverse &= GeneratorUtil.isFirstAttribute((ObjectModelAttribute)attr));
        boolean needsIndex = JavaGeneratorUtil.hasIndexedStereotype((ObjectModelAttribute)attr);
        String cascade = "";
        if (attr.isComposite() || attr.hasAssociationClass()) {
            cascade = " cascade=\"delete,delete-orphan\"";
        }
        String attrType = this.getType(attr);
        String attrName = this.getName(attr);
        String attrColumn = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr);
        String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, TopiaGeneratorUtil.getLazyTagValue(attr), "true");
        String orderBy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_ORDER_BY, TopiaGeneratorUtil.getOrderByTagValue(attr));
        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String tableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
        String inverse = "";
        if (isInverse) {
            inverse = "inverse=\"true\" ";
        }
        String reverseAttrDBName = TopiaGeneratorUtil.getReverseDbName(attr);
        output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" table=\"" + tableName + "\" " + inverse + "" + lazy + "" + cascade + " node=\"" + attrName + "\" embed-xml=\"true\">\n");
        output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"/>\n");
        output.write("");
        if (needsIndex) {
            output.write("" + prefix + "        <list-index column=\"" + reverseAttrDBName + "_idx\"/>\n");
            output.write("");
        }
        output.write("" + prefix + "            <many-to-many class=\"" + attrType + "\" column=\"" + attrColumn + "\" " + orderBy + "node=\"topiaId\"/>\n");
        output.write("" + prefix + "        </" + collType + ">\n");
        output.write("");
    }
}

