package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ExtraDAOEntityAbstract extends TopiaEntityAbstract implements ExtraDAOEntity {

    /**
     * Nom de l'attribut en BD : attr1
     */
    protected String attr1;

    private static final long serialVersionUID = 7161111768716174388L;

    static {
    
        I18n.n_("topia.test.common.extraDAOEntity");
        I18n.n_("topia.test.common.attr1");
    }

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ATTR1, String.class, attr1);
        visitor.end(this);
    }

    @Override
    public void setAttr1(String attr1) {
        String oldValue = this.attr1;
        fireOnPreWrite(PROPERTY_ATTR1, oldValue, attr1);
        this.attr1 = attr1;
        fireOnPostWrite(PROPERTY_ATTR1, oldValue, attr1);
    }

    @Override
    public String getAttr1() {
        fireOnPreRead(PROPERTY_ATTR1, attr1);
        String result = this.attr1;
        fireOnPostRead(PROPERTY_ATTR1, attr1);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_ATTR1, this.attr1).
         toString();
        return result;
    }

} //ExtraDAOEntityAbstract
