package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topiatest.deletetest.Party2DTO;


public class PersonneDTO extends Party2DTO implements Serializable {

    public String name;
    public String[] otherNames;
    public AddressDTO address;
    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);
    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        return name;
    }

    /**
     * setOtherNames :
     * @param values 
     */

    public void setOtherNames(String[] values) {
        java.lang.String[] oldValues = this.otherNames;
        this.otherNames = values;
        p.firePropertyChange("otherNames", oldValues, values);
    }

    /**
     * getOtherNames :
     * @return String[] 
     */

    public String[] getOtherNames() {
        return otherNames;
    }

    /**
     * setAddress :
     * @param value 
     */

    public void setAddress(AddressDTO value) {
        org.nuiton.topiatest.AddressDTO oldValue = this.address;
        this.address = value;
        p.firePropertyChange("address", oldValue, value);
    }

    /**
     * getAddress :
     * @return AddressDTO 
     */

    public AddressDTO getAddress() {
        return address;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("otherNames", this.otherNames).
            append("address", this.address).
         toString();
        return result;
}


} //PersonneDTO
